#!/usr/bin/perl -s
use strict;
use CGI;
use IO::Dir;
use IO::File;

###############################################################################
#
sub get_alignment {
    my($form_opts) = shift;

    #
    print "Content-type: text/plain\n";
    print "\n";

    #
    my($type) = $form_opts->{'type'};

    #
    my($cmd_opts) = '';
    my(@key_list) = keys(%{$form_opts});
    foreach my$key (@key_list) {
        next if ($key eq 'SPEC');

        if ($key =~ /[^0-9a-z\_]/i) {
            print STDERR "WARNING :: 'key' contains invalid character. [$key]\n";
            next;
        }

        my($val) = $form_opts->{"$key"};
        $val = quotemeta($val);

        $cmd_opts .= ' ' if ($cmd_opts ne '');
        $cmd_opts .= qq{-$key="$val"};
    }

    #
    my($dir) = "$ENV{'RECOG_HOME'}/WWW/bin/align.d";
    my($cmd) = "$dir/$type";
    if (-f $cmd && -x $cmd) {
        my($cmd_str) = "$cmd $cmd_opts";
        print `$cmd_str`;
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($form_opts) = {};

    my($cgi) = CGI->new();
    my(@key_list) = $cgi->param();
    foreach my$key (@key_list) {
        $form_opts->{"$key"} = $cgi->param($key);
    }

    get_alignment($form_opts);
}

###############################################################################
1;#
###############################################################################
