#!/usr/bin/perl -s

$WWWROOT = $ENV{'WWWROOT'};

#require 'libCGI.pl';
#require 'libMBGDUserInfo.pl';
#require "MBGD_common.pl";
###%Args = &CGI_GetArgs;

use MBGD::WWW;
use MBGD::ClustTree;


$www = MBGD::WWW->new;
%Args = $www->cgiGetArgs;


#die if (@ARGV == 0);

$| = 1;


my(@entryList);
my($entname);
my($cmd);
my($outfile);
my(@work);

# 򥯥饹 ORF 
$orfList = '';
if (defined $Args{clustid}) {
	my $tabid = $www->uInfo->currentTableID;
	my($tree, @trees);
	foreach $clustid (split(/,/, $Args{clustid})) {
		$tree = MBGD::ClustTree::DB::getTree($tabid, $Args{clustid});
		push(@trees, $tree);
	}
	my $treeobj = MBGD::ClustTree->new(\@trees);
	@entryList = $treeobj->getorfs;
} elsif (defined $Args{'genes'}) {
    foreach $g (split(/,/, $Args{'genes'})) {
        push(@entryList, $g);
    }
} else {
    @entryList = split(/,/, $Args{'cluster'});
    shift(@entryList);
}
if ($Args{'size'} =~ /^\d+,\d+$/) {
	$CONVGRAPH_OPT .= "-size=$Args{'size'}";
}

##$Args{type} = 'ps' if (! $Args{type});

$entnames = join(' ', @entryList);

$outfile = "$DIR_tmp/dot$$";
$OPT = "-o6";
$cmd  = "$WWWROOT/bin/hcluster.pl -OPT='$OPT' $entnames";
$cmd .= "| $WWWROOT/bin/convgraph.pl $CONVGRAPH_OPT ";
$cmd .= "| $CMD_dot -Tps -o $outfile.ps";
print STDERR "CMD :: $cmd\n";
system("$cmd");

print STDERR "TYPE :: $Args{'type'}\n";

if ($Args{'type'} =~ /ps/i) {
    # ݥȥץȷʼǽ
    print "Content-type: application/postscript\n";
    print "Content-length: ", (-s "$outfile.ps"), "\n";
    print "\n";
    $cmd = "$CMD_cat $outfile.ps";
    system("$cmd");

    unlink("$outfile.ps");
    exit;
}


# GIF Ѵ
$cmd = "$CMD_convert $outfile.ps $outfile.gif";
system("$cmd");

print "Content-type: image/gif\n";
print "Content-length: ", (-s "$outfile.gif"), "\n";
print "\n";
$cmd = "$CMD_cat $outfile.gif";
system("$cmd");

unlink("$outfile.ps");
unlink("$outfile.gif");

