#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub exists_user {
    my($form_opt) = shift;

    my($user_email) = $form_opt->{'user_email'};
    my($is_valid_email) = RecogProjectCommon::is_valid_email($user_email);
    my($sta) = RecogProjectCommon::exists_user_name($user_email);

    print "Content-type: text/html\n";
    print "\n";
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print "</head>\n";
    print "<body>\n";
    print "<h1>User name</h1>\n";
    if (!$user_email || !$is_valid_email) {
        print "Sorry, invalid email address. [$user_email]\n";
    }
    elsif ($sta) {
        print "Already used this email address. [$user_email]\n";
    }
    else {
        print "This email address is free. [$user_email]\n";
    }

    print qq{<input type="button" name="btn_close" value="Close" onclick="self.close();">\n};
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('user_email') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    exists_user($form_opt);
}

###############################################################################
1;#
###############################################################################
