#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use MBGD::DB;
use RecogProjectCommon;
use RecogBuild;
use RECOG::RecogProject;
require "MBGD_Conf.pl";

###############################################################################
sub build_homology_all {
    my($formOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($name) = 'Build-homology-db';
    my($cgi) = "/htbin/recog_build/build_homology_all.cgi";
    my($file_pid) = "$ENV{'RECOG_HOME'}/etc/$name.pid";
    my($file_err) = "$ENV{'RECOG_HOME'}/etc/$name.err";
    my($t) = $formOpt->{'t'};
    $t = int($t * 1.2);
    if (60 < $t) {
        $t = 60;
    }

    #
    my($pid) = $formOpt->{'pid'};
    if ($pid) {
        my($sta) = kill(0 => $pid);
        if ($sta) {
            # running!
            my($file_status) = "$ENV{'MBGD_HOME'}/work/build_status.$pid";
            RecogBuild::print_html_running_update($name, $cgi, $pid, $t, $file_status);
        }
        else {
            # finished
            my($msg) = '';
            if (-e $file_err) {
                # Found err
                my($fh) = FileHandle->new("$file_err");
                $msg = join("<br>", $fh->getlines());
                $fh->close();
            }
            RecogBuild::print_html_finished_update($name, $msg);
        }
        exit(0);
    }

    #
    if (-e $file_pid) {
        my($fh) = FileHandle->new("$file_pid") || die("Can not open $file_pid($!)");
        $pid = $fh->getline();
        $pid =~ s#[\r\n]*$##;
        $fh->close();

        my($sta) = kill(0 => $pid);
        if (!$sta) {
            # NOT found :: PID=$pid
            unlink("$file_pid");
        }
        else {
            RecogBuild::print_html_running_update($name, $cgi, $pid, $t);
            exit(0);
        }
    }

    #
    my($pid) = fork();
    if ($pid) {
        sleep(2);
        RecogBuild::print_html_running_update($name, $cgi, $pid, $t);
        exit(0);
    }

    #
    close(STDIN);
    close(STDOUT);
    close(STDERR);

    my($force_rebuild) = $formOpt->{'force_rebuild'};

    #
    if (!-e $file_pid) {
        my($fh) = FileHandle->new(">$file_pid") || die("Can not open $file_pid($!)");
        $fh->print($$, "\n");
        $fh->close();
    }
    unlink($file_err);

    #
    #
    my($file_status) = "$ENV{'MBGD_HOME'}/work/build_status.$$";
    my($file_log)    = "$ENV{'MBGD_HOME'}/work/build_log.$$";

    #
    my($project_ref) = RECOG::RecogProject->new();
    my(@spid_list) = $project_ref->get_spid_list_all($user);
    RecogBuild::build_homology_all($force_rebuild, $file_status, $file_log, @spid_list);

    unlink($file_pid);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    my(@key_list) = ('pid', 't', 'force_rebuild');
    foreach my$key (@key_list) {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    build_homology_all($formOpt);
}

###############################################################################
1;#
###############################################################################
