#!/usr/bin/perl -s
use strict;
use CGI;
use FileHandle;
use MBGD::DB;
use RecogProjectCommon;
require "MBGD_Conf.pl";
require "InfoSpec.pl";

###############################################################################
sub print_html_header {
    my($pid) = shift;
    my($t) = shift;

    my($html_reload) = '';
    if (0 < $t) {
        my($uri) = qq{/htbin/recog_build/copy_public_species.cgi?pid=$pid&t=$t};
        $html_reload = qq{<meta http-equiv="refresh" content="$t;URL=$uri">};
    }

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
$html_reload
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>
EOB

    return;
}

###############################################################################
sub print_html_running {
    my($pid) = shift;
    my($t) = shift;

    if ($t < 5) {
        $t = 5;
    }

    print_html_header($pid, $t);

    print <<EOB;
<body>
<h1>Copy species</h1>
<h2>Running...</h2>
$pid : $t
</body>
</html>
EOB

    return;
}

###############################################################################
sub print_html_finished {
    my($msg) = shift;

    print_html_header();

    my($html_msg) = '';
    if ($msg) {
        $html_msg = '<h3>Found error(s)</h3>' . $msg;
    }

    print <<EOB;
<h1>Copy species</h1>
<h2>Done.</h2>
$html_msg
</body>
</html>
EOB

    return;
}

###############################################################################
sub copy_species {
    my($formOpt) = shift;

    my($user) = $ENV{'REMOTE_USER'};
    my($proj_id) = $formOpt->{'project_id'};

    my($proj_ref);
    if ($proj_id) {
        my($dbname) = $main::DBNAME_ACCUM;
        my($db) = MBGD::DB->new($dbname);
        $proj_ref = RecogProjectCommon::get_project($db, $proj_id, $user);

        if (!$proj_ref) {
            # No project
            exit(0);
        }
    }

    #
    my($file_pid) = "$ENV{'RECOG_HOME'}/etc/copy_species.pid";
    my($file_err) = "$ENV{'RECOG_HOME'}/etc/copy_species.err";
    my($t) = $formOpt->{'t'};
    $t = int($t * 1.2);
    if (60 < $t) {
        $t = 60;
    }

    #
    my($pid) = $formOpt->{'pid'};
    if ($pid) {
        my($sta) = kill(0 => $pid);
        if ($sta) {
            # running!
            print_html_running($pid, $t);
        }
        else {
            # finished
            my($msg) = '';
            if (-e $file_err) {
                # Found err
                my($fh) = FileHandle->new("$file_err");
                $msg = join("<br>", $fh->getlines());
                $fh->close();
            }
            print_html_finished($msg);
        }
        exit(0);
    }

    #
    if (-e $file_pid) {
        my($fh) = FileHandle->new("$file_pid") || die("Can not open $file_pid($!)");
        $pid = $fh->getline();
        $pid =~ s#[\r\n]*$##;
        $fh->close();

        my($sta) = kill(0 => $pid);
        if (!$sta) {
            # NOT found :: PID=$pid
            unlink("$file_pid");
        }
        else {
            print_html_running($pid, $t);
            exit(0);
        }
    }

    #
    my($pid) = fork();
    if ($pid) {
        sleep(2);
        print_html_running($pid, $t);
        exit(0);
    }

    #
    close(STDIN);
    close(STDOUT);
    close(STDERR);

    #
    if (!-e $file_pid) {
        my($fh) = FileHandle->new(">$file_pid") || die("Can not open $file_pid($!)");
        $fh->print($$, "\n");
        $fh->close();
    }

    #
    my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab.dist";
    my($spid_dist_ref) = getInfoSpecTab($file_spid_tab);

    #
    my($dir) = "$ENV{'RECOG_HOME'}/species";
    mkpath($dir, 0, 0750);

    #
    my(@spid_list) = split(/,/, $proj_ref->{'spid'});
    my($cmd) = "$ENV{'RECOG_HOME'}/build/mirrorSpidData.pl @spid_list";
    my($cmd) = "$ENV{'RECOG_HOME'}/build/mirrorBldpData.pl @spid_list";

    #
    unlink($file_pid);
    unlink($file_err);

    return;
}

################################################################################
if ($0 eq __FILE__) {
    my($cgi)  = CGI->new();

    my($formOpt) = {};
    foreach my$key ('pid', 't', 'project_id') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    copy_species($formOpt);
}
1;#
