#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
require "InfoSpec.pl";

################################################################################
sub copy_public_species_win {
    my($formOpt) = shift;

    my($user) = $ENV{'REMOTE_USER'};
    my($proj_id) = $formOpt->{'project_id'};

    #
    my($dbname) = $main::DBNAME_ACCUM;
    my($db) = MBGD::DB->new($dbname);

    my($proj_ref) = RecogProjectCommon::get_project($db, $proj_id, $user);

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>
EOB

    print qq{<h1>Copy species</h1>\n};
    print qq{Download from <a href="http://mbgd.genome.ad.jp">mbgd.genome.ad.jp</a>\n};
    print "<p>";
    print "Species :: ";

    #
    my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab.dist";
    my($spid_dist_ref) = getInfoSpecTab($file_spid_tab);

    my(@html_spec_list);
    my(@spid_list) = split(/,/, $proj_ref->{'spid'});
    foreach my$spid (sort(@spid_list)) {
        my($sp) = $spid_dist_ref->{'SPID2NAME'}->{"$spid"};
        push(@html_spec_list, "$sp($spid)");
    }
    print join(",", @html_spec_list);

    #
    print qq{<form name="frm_copy_species" method="post" action="/htbin/recog_build/copy_public_species.cgi">};
    print qq{<input type="hidden" name="project_id" value="$proj_id">};
    print qq{<input type="button" name="btn_start" value="Copy" onclick="copy_public_species();">};
    print qq{</form>};

    return;
}

################################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    #
    my($formOpt) = {};
    foreach my$key ('project_id') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    copy_public_species_win($formOpt);
}
1;#
