#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use File::Path;
use MBGD::WWW;
use MbgdUserGenomeCommon;

###############################################################################
#
sub delUserChromosome {
    my($uid) = shift;
    my($formOpt) = shift;

    my($idUserGenome)     = $formOpt->{'id_user_genome'};
    my($idUserChromosome) = $formOpt->{'id_user_chromosome'};

    #
    my($spUg) = MbgdUserGenomeCommon::getUserGenomeSpec($idUserGenome);
    MbgdUserGenomeCommon::clearBlastFinishedSpec($uid, $spUg);

    #
    my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $idUserChromosome);
    if (-e "$dirUc") {
        # UserChromosome 
        MbgdUserGenomeCommon::deleteUserChromosome($uid,
                                                   $idUserGenome,
                                                   $idUserChromosome);

        #
        my($cid);
        for($cid = $idUserChromosome; $cid < $MbgdUserGenomeCommon::MAX_USER_CHROMOSOME; $cid++) {
            my($dirUcCurr) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $cid);
            my($dirUcNext) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $cid + 1);
            if (! -e "$dirUcNext") {
                last;
            }
            rename($dirUcNext, $dirUcCurr);
        }
    }

    #
    $idUserChromosome = MbgdUserGenomeCommon::getFirstUserChromosomeId($uid, $idUserGenome);

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mymbgd.css" type="text/css" />
<script language="JavaScript" src="/js/mymbgd.js"></script>
</head>

<body onload="updateUserGenomeList(); updateUserChromosomeList($idUserGenome);">

<form>
Deleted.<br>
<input type="button" value="Ok" onclick="updateUserChromosome('$idUserGenome', '$idUserChromosome');">
</form>

</body>
</html>
EOB

}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    my($key);

    #
    my($cgi) = new CGI();

    my($formOpt) = {};

    foreach $key ('id_user_genome', 'id_user_chromosome') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    delUserChromosome($uid, $formOpt);
}
###############################################################################
1;#
###############################################################################
