#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use File::Path;
use MBGD::WWW;
use MbgdUserGenomeCommon;


###############################################################################
#
sub delUserGenome {
    my($uid) = shift;
    my($formOpt) = shift;

    my($idUserGenome)     = $formOpt->{'id_user_genome'};
    my($dirUg) = MbgdUserGenomeCommon::getDirUserGenome($uid, $idUserGenome);
    if (-e "$dirUg") {
        # UserGenome 
        MbgdUserGenomeCommon::deleteUserGenome($uid, $idUserGenome);
        my($spidUg) = MbgdUserGenomeCommon::getUserGenomeSpid($formOpt->{'id_user_genome'});
        my($specUg) = MbgdUserGenomeCommon::getUserGenomeSpec($formOpt->{'id_user_genome'});

        #
        my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab";
        my($spid_tab_ref) = getInfoSpecTab($file_spid_tab);
        if (exists($spid_tab_ref->{'NAME2DIR'}->{"$specUg"})) {
            my($dirUg) = "$ENV{'MBGD_HOME'}/species/$spidUg";
            delInfoSpecTabEntry($spid_tab_ref, $spidUg);
            setInfoSpecTab($file_spid_tab, $spid_tab_ref);
        }
    }

    #
    $idUserGenome = MbgdUserGenomeCommon::getFirstUserGenomeId($uid);

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mymbgd.css" type="text/css" />
<script language="JavaScript" src="/js/mymbgd.js"></script>
</head>

<body onload="updateUserGenomeList(); clearUserChromosome();">

<form>
Deleted.<br>
<input type="button" value="Ok" onclick="updateUserGenome('$idUserGenome');">
</form>

</body>
</html>
EOB

}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    my($key);

    #
    my($cgi) = new CGI();

    my($formOpt) = {};

    foreach $key ('id_user_genome') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    delUserGenome($uid, $formOpt);
}
###############################################################################
1;#
###############################################################################
