#!/usr/bin/perl -s
use strict;
use CGI;
use DirHandle;
use FileHandle;
use MBGD::DB;
use RecogProjectCommon;
require "MBGD_Conf.pl";
require "InfoSpec.pl";

###############################################################################
sub load_genome_txt {
    my($spid) = shift;

    #
    my($ref) = {};
    my($dir) = sprintf("%s/species/%s", $ENV{'RECOG_HOME'}, $spid);
    my($filename) = "$dir/gm/genome.txt";
    my($fh) = FileHandle->new("$filename") || return $ref;
    while (my$line=$fh->getline()) {
        $line =~ s#[\r\n]*$##;

        my($key, $val) = split(/\t/, $line);
        $ref->{"$key"} = $val;
    }
    $fh->close();

    return $ref;
}

###############################################################################
sub print_html_spid_head {

    print qq{<tr class="spec_list fc_h">\n};
    print qq{<th></th>\n};
    print qq{<th></th>\n};
    print qq{<th>SPID</td>\n};
    print qq{<th>SP</td>\n};
    print qq{<th>Fullname</td>\n};
    print qq{<th>Abbrev.</td>\n};
    print qq{<th>Strain</td>\n};
    print qq{<th>Taxonomy ID</td>\n};
    print qq{<th>Release</td>\n};
    print qq{<th>Modify</td>\n};
    print qq{<th>Modify(server)</td>\n};
    print qq{</tr>\n};

    return;
}

###############################################################################
sub print_html_spid {
    my($proj_name) = shift;
    my($spid) = shift;
    my($ref_srv) = shift;

    my($ref) = load_genome_txt($spid);

    #
    my($date_modify_srv) = $ref_srv->{'date_modify'};
    my($date_modify_loc) = $ref->{'date_modify'};
    my($sta_checked) = 'checked';
    if ($date_modify_loc && ($date_modify_srv le $date_modify_loc)) {
        $sta_checked = '';
    }

    #
    print qq{<tr class="spec_list fc_h">\n};

    #
    print "<td>";
    if ($spid =~ /^gm\d+$/) {
        print qq{<input type="checkbox" name="upd_spid" value="$spid" $sta_checked>};
    }
    print "</td>\n";

    #
    print qq{<td><input type="button" name="btn_del" value="DEL" onclick="del_public_species('$proj_name', '$spid');"></td>\n};

    #
    print qq{<td>$spid</td>\n};
    if ($ref->{'sp'}) {
        foreach my$k ('sp', 'orgname', 'abbrev', 'strain', 'taxid', 'date_release', 'date_modify') {
            print qq{<td nowrap>$ref->{"$k"}</td>\n};
        }

        my($bgc) = '';
        if ($sta_checked) {
            $bgc = '#ffffaa';
        }
        print qq{<td bgcolor="$bgc" nowrap>$ref_srv->{'date_modify'}</td>\n};
    }
    else {
        print qq{<td colspan="99">Not downloaded</td>\n};
    }
    print qq{</tr>\n};

    return;
}

###############################################################################
sub list_species_win {
    my($formOpt) = shift;

    my($user) = $ENV{'REMOTE_USER'};
    my($proj_name) = $formOpt->{'project_id'};

    #
    my($proj_ref) = RecogProjectCommon::get_project($proj_name);
    my($proj_name) = $proj_ref->{'NAME'};
    my(@spid_list) = @{$proj_ref->{'SPID_LIST'}};

    #
    my($ginfo_ref) = {};
    my($file_pubspec) = "$ENV{'MBGD_HOME'}/etc/'
                      . $main::NAME_PUBLIC_SERVER
                      . '/species";
    my(@key_list);
    my($fh) = FileHandle->new("$file_pubspec") || die("Can not open $file_pubspec($!)");
    while (my$line=$fh->getline()) {
        $line =~ s#[\r\n]*$##;

        if ($line =~ /^id/) {
            @key_list = split(/\t/, $line);
        }
        else {
            my(@d) = split(/\t/, $line);
            my($ref) = {};
            foreach my$key (@key_list) {
                $ref->{"$key"} = shift(@d);
            }

            my($spid) = $ref->{'spid'};
            $ginfo_ref->{"$spid"} = $ref;
        }
    }
    $fh->close();

    #
    my($file_spid_tab) = "$ENV{'RECOG_HOME'}/etc/spid.tab.dist";
    my($spid_dist_ref) = getInfoSpecTab($file_spid_tab);

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<?xml version="1.0" encoding="EUC-JP">
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_build.js"></script>
<script language="JavaScript" src="/js/recog_project.js"></script>

</head>

<body>

<h1>List species for project [$proj_name]</h1>

<form name="frm_list_spec">
<input type="button" name="btn_upd" value="Download public species" onclick="update_public_species();"><br>
EOB

    #
    print <<EOB;
<table id="spec_list" class="spec_list" border>
EOB

    print_html_spid_head();

    #
    if (scalar(@spid_list) == 0) {
        print qq{<tr><th>No species</th></tr>};
    }
    else {
        my($func_ref) = sub {
            my($type_a, $spseq_a) = ($a =~ /^(g[mu])(\d+)$/);
            my($type_b, $spseq_b) = ($b =~ /^(g[mu])(\d+)$/);

            return $type_b cmp $type_a
                        or
                    $spseq_a <=> $spseq_b;
        };
        foreach my$spid (sort $func_ref @spid_list) {
            my($ref) = $ginfo_ref->{"$spid"};
            print_html_spid($proj_name, $spid, $ref);
        }
    }

    print <<EOB;
</tbody>
<tfoot></tfoot>
</table>
<input type="hidden" name="upd_spid" value=""><!-- dummy -->
<input type="hidden" name="upd_spid" value=""><!-- dummy -->
</form>

<form name="frm_upd_public_spec" method="post" action="/htbin/recog_build/update_public_species.cgi" target="win_upd_public_spec">
<input type="hidden" name="spid" value="">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    foreach my$key ('project_id') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    list_species_win($formOpt);
}

###############################################################################
1;#
###############################################################################
