#!/usr/bin/perl -s
use strict;
use CGI;
use FileHandle;
use RecogBuild;
use RECOG::RecogProject;
require "MBGD_Conf.pl";

###############################################################################
sub update_base_cluster {
    my($formOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($name) = 'Update-base-cluster';
    my($cgi) = "/htbin/recog_build/update_base_cluster.cgi";
    my($file_pid) = "$ENV{'RECOG_HOME'}/etc/$name.pid";
    my($file_err) = "$ENV{'RECOG_HOME'}/etc/$name.err";
    my($t) = $formOpt->{'t'};
    $t = int($t * 1.2);
    if (60 < $t) {
        $t = 60;
    }

    #
    my($pid) = $formOpt->{'pid'};
    if ($pid) {
        my($sta) = kill(0 => $pid);
        if ($sta) {
            # running!
            RecogBuild::print_html_running_update($name, $cgi, $pid, $t);
        }
        else {
            # finished
            my($msg) = '';
            if (-e $file_err) {
                # Found err
                my($fh) = FileHandle->new("$file_err");
                $msg = join("<br>", $fh->getlines());
                $fh->close();
            }
            RecogBuild::print_html_finished_update($name, $msg);
        }
        exit(0);
    }

    #
    if (-e $file_pid) {
        my($fh) = FileHandle->new("$file_pid") || die("Can not open $file_pid($!)");
        $pid = $fh->getline();
        $pid =~ s#[\r\n]*$##;
        $fh->close();

        my($sta) = kill(0 => $pid);
        if (!$sta) {
            # NOT found :: PID=$pid
            unlink("$file_pid");
        }
        else {
            RecogBuild::print_html_running_update($name, $cgi, $pid, $t);
            exit(0);
        }
    }

    #
    my($pid) = fork();
    if ($pid) {
        sleep(2);
        RecogBuild::print_html_running_update($name, $cgi, $pid, $t);
        exit(0);
    }

    #
    close(STDIN);
    close(STDOUT);
#    close(STDERR);

    #
    if (!-e $file_pid) {
        my($fh) = FileHandle->new(">$file_pid") || die("Can not open $file_pid($!)");
        $fh->print($$, "\n");
        $fh->close();
    }
    unlink($file_err);

    #
    my($project_ref) = RECOG::RecogProject->new();

    #
    my($ret) = RecogBuild::update_base_cluster($project_ref, $user);
    if ($ret >> 8 != 0) {
        my($fhe) = IO::File->new(">$file_err");
        if ($fhe) {
            $fhe->printf("ERROR :: Update base cluster [$ret]");
            $fhe->close();
        }
    }

    unlink($file_pid);

    return;
}

################################################################################
if ($0 eq __FILE__) {
    my($cgi)  = CGI->new();

    my($formOpt) = {};
    foreach my$key ('pid', 't') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    update_base_cluster($formOpt);
}
1;#
