#!/usr/bin/perl -s
use strict;
use CGI;
use FileHandle;
use GenBank;
use MBGD::WWW;

###############################################################################
#
sub printGeneEntries {
    my($genbank) = shift;
    my($chr_ref) = shift;

    print "<h1></h1>\n";

#    my(@err_msg) = $genbank->get_status_read_entry();
#    if (scalar(@err_msg) != 0) {
#        print "<h2>ERROR</h2>";
#        foreach my$msg (@err_msg) {
#            print $msg, "<br>\n";
#        }
#    }

    #
    my($disp_entries) = '';
    my($n_cds) = 0;
    my($n_cds_protseq) = 0;
    foreach my$ent (@{$genbank->{'data'}->{'features'}}) {
        my($keyname) = $ent->{'keyname'};
        my($from, $to, $dir) = $genbank->get_region($ent->{'location'});
        ($from)  = ($from =~ /(\d+)/);
        ($to)    = ($to   =~ /(\d+)/);

        if (($keyname !~ /^cds$/i) &&
            ($keyname !~ /^.*rna$/i)) {
            next;
        }

        if (exists($ent->{'attr'}->{"pseudo"})) {
            # pseudo gene $B$G$"$k(B ---> SKIP
            next;
        }

        $disp_entries .= "<tr>\n";
        $disp_entries .= "<td>$ent->{'attr'}->{'locus_tag'}</td>";
        $disp_entries .= "<td>$ent->{'attr'}->{'gene'}</td>";

        # $B%3%s%^$rA^F~$7=PNO(B
        while ($from =~ s#^([\+\-]?\d+)(\d{3})#$1,$2#) { ; };
        $disp_entries .= "<td align=right>$from</td>";

        # $B%3%s%^$rA^F~$7=PNO(B
        while ($to =~ s#^([\+\-]?\d+)(\d{3})#$1,$2#) { ; };
        $disp_entries .= "<td align=right>$to</td>";

        #
        $disp_entries .= "<td align=right>$dir</td>";
        $disp_entries .= "<td>$keyname</td>";
        $disp_entries .= "<td>$ent->{'attr'}->{'product'}</td>";

        my($style) = '';
        if ($keyname =~ /^cds$/i) {
            $n_cds++;
            if ($ent->{'attr'}->{'translation'} =~ /^\s*$/) {
                $style = 'background-color:red;';
            }
            else {
                $n_cds_protseq++;
            }
        }
        $disp_entries .= "<td style=\"$style\">$ent->{'attr'}->{'translation'}</td>";
        $disp_entries .= "\n";
        $disp_entries .= "</tr>\n";
    }

    #
    print "<h2>Your Saved Data (" . $chr_ref->{'chromosome_name'} . ")</h2>\n";
    print "<b>Please check whether the data have been correctly saved.</b><br>\n";
    print "<table border>\n";
    print "<tr><th>CDS</td>\n";
    print "    <td>$n_cds</td>\n";
    print "<tr/>\n";
    print "<tr><th>Protein Sequence(CDS)</td>\n";
    print "    <td>$n_cds_protseq</td>\n";
    print "<tr/>\n";
    print "</table>\n";
    print "<table style=\"empty-cells:show;\" border>\n";
    print "<tr>\n";
    print "<th>Name</th>";
    print "<th>Gene</th>";
    print "<th>From</th>";
    print "<th>To</th>";
    print "<th>Direction</th>";
    print "<th>Type</th>";
    print "<th>Description</th>";
    print "<th>Protein Sequence</th>";
    print $disp_entries;
    print "</tr>\n";

    print "</table>\n";

    return;
}

###############################################################################
#
sub viewGbkFile {
    my($uid) = shift;
    my($formOpt) = shift;
    my($idUserGenome)     = $formOpt->{'id_user_genome'};
    my($idUserChromosome) = $formOpt->{'id_user_chromosome'};

    #
    my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $idUserChromosome);
    my($fileGbk) = "$dirUc/ncbiGbk";
    my($genbank) = new GenBank($fileGbk);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<"END_HTML";
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mymbgd.css" type="text/css" />
</head>
<body>
END_HTML

    my($chr_ref) = MbgdUserGenomeCommon::loadUserChromosomeInfo($uid, $idUserGenome, $idUserChromosome);
    while ($genbank->read_entry()) {
	    printGeneEntries($genbank, $chr_ref);
    }

    print <<"END_HTML";
</body>
</html>
END_HTML

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    my($key);

    #
    my($cgi) = new CGI();

    my($formOpt) = {};
    foreach my$key ('id_user_genome', 'id_user_chromosome') {
        $formOpt->{"$key"} = $cgi->param($key);
    }

    viewGbkFile($uid, $formOpt);
}

###############################################################################
1;#
###############################################################################
