#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::WWW;
use MbgdUserGenomeCommon;

###############################################################################
#
sub viewUserChromosomeListWin {
    my($uid) = shift;
    my($formOpt) = shift;

    #
    my(@listUserChromosome);
    my($idUserGenome) = $formOpt->{'id_user_genome'};
    my($refUserGenome);
    my($idUserChromosome);
    my($refUserChromosome) = {};

    if ($idUserGenome != 0) {
        $refUserGenome = MbgdUserGenomeCommon::loadUserGenomeInfo($uid, $idUserGenome);

        # UserGenome ϿƤ Chromosome 
        for($idUserChromosome = 1; $idUserChromosome <= $MbgdUserGenomeCommon::MAX_USER_CHROMOSOME; $idUserChromosome++) {
            my($dirUc) = MbgdUserGenomeCommon::getDirUserChromosome($uid, $idUserGenome, $idUserChromosome);
            if (! -e $dirUc) {
                next;
            }

            $refUserChromosome = MbgdUserGenomeCommon::loadUserChromosomeInfo($uid, $idUserGenome, $idUserChromosome);
            push(@listUserChromosome, $refUserChromosome);
        }
    }

    my($html_predict) = '';
#    if (scalar(@listUserChromosome) != 0) {
#        # UserChromosome ϿѤߤξΤɽ
#        $html_predict = qq{
#<input type="button" name="btn_predit_genes" value="Predict genes" onclick="predict_genes();">
#};
#    }

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<EOB;
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<title></title>
<link rel="stylesheet" href="/css/mymbgd.css" type="text/css" />
<script>
function addUserChromosome(gid) {
    var doc = document;
    var win;

    var mod = doc.frm_list_chromosome.chromosome_data_type.value;

    win = open('', 'mod_user_chromosome');
    win.location = '/htbin/recog_build/modUserChromosomeWin.cgi?id_user_genome=' + gid + '&id_user_chromosome=-1' + '&chromosome_data_type=' + mod;

    window.reload();

    return;
}

function deleteUserChromosome(gid, cid) {
    var win;

    var sta = confirm('Delete this chromosome.\\nAre you sure?');
    if (! sta) {
        return;
    }

    win = open('', 'mod_user_chromosome');
    win.location = '/htbin/recog_build/delUserChromosome.cgi?id_user_genome=' + gid + '&id_user_chromosome=' + cid;
}


function predict_genes() {
    var doc = this.document;

    var msg = "If you start prediction, 'gene informations' will be overwritten.\\n"
            + "Are you sure?";
    var sta = confirm(msg);
    if (!sta) {
        // STOP predict
        return;
    }

    doc.form_predict.submit();

    return;
}

</script>
</head>

<body>
<form name="frm_list_chromosome">
<table bgcolor="#007000" width="100%">
<tr><td><font color="#e8f8e8">User Chromosome List</font>$html_predict</td>
</tr>

<tr><td>
<table bgcolor="#e8f8e8" width="100%" border>
EOB

    if (scalar(@listUserChromosome) == 0) {
            print <<EOB;
<tr><td>No User Chromosome</td></tr>
EOB

    }
    else {
            print <<EOB;
EOB

        print <<EOB;
<tr><th nowrap>Name</th>
    <th width="3%" nowrap>Status</th>
    <th width="3%" nowrap>Del</th>
</tr>
EOB

        my($cid) = 1;
        foreach $refUserChromosome (@listUserChromosome) {
            my($name_chr) = $refUserChromosome->{'chromosome_name'};
            if (!$name_chr) {
                $name_chr = "[chr $cid]";
            }
            print <<EOB;
<tr><td nowrap><a href="/htbin/recog_build/modUserChromosomeWin.cgi?id_user_genome=$idUserGenome&id_user_chromosome=$cid" target="mod_user_chromosome">$name_chr</a></td>
    <td align="center" nowrap>$refUserChromosome->{'status'}</td>
    <td align="center" nowrap>
        <input type="button" name="btn_del" value="Del" onclick="deleteUserChromosome($idUserGenome, $cid);"></td>
</tr>
EOB
            $cid++;
        }
    }

    print <<EOB;
</table>
EOB

    #
    print <<EOB;
    </td>
</tr>
</table>
EOB

    if ($MbgdUserGenomeCommon::MAX_USER_CHROMOSOME <= scalar(@listUserChromosome)) {
        # UserChromosome ξ
        print <<EOB;
[No More Chromosome]
EOB
    }
#    elsif (scalar(@listUserChromosome) != 0) {
    else {
        # UserChromosome ϿѤߤξΤɽ
        my($complete_genbank) = join(':', $MbgdUserGenomeCommon::MODE_USERCHR_complete,
                                          $MbgdUserGenomeCommon::MODE_USERCHR_genbank);
        my($complete_genetab_protseq) = join(':', $MbgdUserGenomeCommon::MODE_USERCHR_complete,
                                                  $MbgdUserGenomeCommon::MODE_USERCHR_genetab_proteinseq);
        my($predict_dnaseq) = join(':', $MbgdUserGenomeCommon::MODE_USERCHR_predict,
                                        $MbgdUserGenomeCommon::MODE_USERCHR_dnaseq);
        my($draft_genbank) = join(':', $MbgdUserGenomeCommon::MODE_USERCHR_metagenome,
                                          $MbgdUserGenomeCommon::MODE_USERCHR_genbank);
        my($draft_protseq) = join(':', $MbgdUserGenomeCommon::MODE_USERCHR_metagenome,
                              $MbgdUserGenomeCommon::MODE_USERCHR_proteinseq);
        my($draft_genetab_protseq) = join(':', $MbgdUserGenomeCommon::MODE_USERCHR_metagenome,
                              $MbgdUserGenomeCommon::MODE_USERCHR_genetab_proteinseq);

	my($select_draft_genbank);
	if ($refUserGenome->{type} =~ /incomplete|metagenome/) {
		$select_draft_genbank = 'selected';
	}
        print <<EOB;
Type: <select name="chromosome_data_type">
<optgroup label="Complete Data">
<option value="$complete_genbank">GenBank</option>
<option value="$complete_genetab_protseq">GeneTab + ProteinSeq</option>
</optgroup>
<!--
<optgroup label="Predict">
<option value="$predict_dnaseq">DnaSeq</option>
</optgroup>
-->
<optgroup label="draft/metagenome">
<option value="$draft_genbank" $select_draft_genbank>GenBank (multiple)</option>
<option value="$draft_genetab_protseq">GeneTab + ProteinSeq</option>
<option value="$draft_protseq">ProteinSeq</option>
</optgroup>
</select>
<input type="button" value="Create New Chromosome" onclick="addUserChromosome($idUserGenome);">
EOB
    }

    print <<EOB;
</form>

<form name="form_predict" method="post" action="/htbin/recog_build/predictUserGenome.cgi" target="win_predict">
<input type="hidden" name="id_user_genome" value="$idUserGenome">
</form>

</body>
</html>
EOB
}

###############################################################################
if ($0 eq __FILE__) {
    my($WWW) = MBGD::WWW->new;
    my($uid) = $WWW->uid();

    my($key);

    #
    my($cgi) = new CGI();

    my($formOpt) = {};

    $key = 'id_user_genome';
    $formOpt->{"$key"} = $cgi->param($key);

    viewUserChromosomeListWin($uid, $formOpt);

    exit(0);
}
###############################################################################
1;#
###############################################################################
