#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;

###############################################################################
#
sub view_build_log {
    my($pid) = shift;

    print "Content-type: text/html\n";
    print "\n";

    #
    print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<link rel="stylesheet" type="text/css" href="/css/recog_build.css" />
<script type="text/javascript" src="/js/common.js"></script>
<script type="text/javascript" src="/js/mbgd.js"></script>
<script type="text/javascript" src="/js/organism_selection.js"></script>
<script type="text/javascript" src="/js/create_tax.js"></script>
<script type="text/javascript" src="/js/recog_common.js"></script>
<script type="text/javascript" src="/js/recog_build.js"></script>
</head>
<body>
<h1>Build log</h1>
<pre>
EOB

    #
    $pid =~ s#[^0-9]##g;
    my($file_log) = "$ENV{'MBGD_HOME'}/work/build_log.$pid";
    my($log);
    my($fh) = IO::File->new("$file_log");
    if ($fh) {
        while (my$line=$fh->getline()) {
            print $line;
        }
        $fh->close();
    }

print <<EOB;
</pre>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($pid) = $cgi->param('pid');
    view_build_log($pid);
}

###############################################################################
1;#
###############################################################################
