#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;
require 'libMBGDaxes.pl';

###############################################################################
sub add_project_user {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($proj_id)   = $form_opt->{'project_id'};
    my($user_name) = $form_opt->{'user_name'};

    my($auth) = RECOG::RecogProject->new();

    #
    my($sta) = $auth->exists_project($user, $proj_id);
    if (!$sta) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($sta_sys) = $auth->permit_project_user($user,
                                              $RECOG::RecogProject::ID_PRJ_system,
                                              $RECOG::RecogProject::ACT_ADD_USR);
    my($sta_prj) = $auth->permit_project_user($user,
                                              $proj_id,
                                              $RECOG::RecogProject::ACT_ADD_USR);
    if (!$sta_sys && !$sta_prj) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my($sta) = $auth->exists_user($user, $user_name);
    if (!$sta) {
        my($msg) = "You can not add this user.";
        $auth->print_html_sorry($user, $msg);
        exit(0);
    }

    #
    my($sta) = $auth->exists_project_user($user,
                                          $proj_id,
                                          $user_name);
    if ($sta) {
        my($msg) = "Already exists.";
        $auth->print_html_sorry($user, $msg);
        exit(0);
    }

    #
    my($sta) = $auth->add_project_user($user,
                                       $proj_id,
                                       $user_name);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Add project member</h1>\n";

    print <<EOB;
Done.<br>
<input type="button" name="btn_close" value="Close" onclick="window.close();">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id', 'user_name');
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    add_project_user($form_opt);
}

###############################################################################
1;#
###############################################################################
