#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;
require 'libMBGDaxes.pl';
require "InfoSpec.pl";

###############################################################################
#
sub delete_base_cluster_conf {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};

    #
    my($dir_base_cluster) = sprintf("%s/database.work/base_cluster/%d.d", $ENV{'RECOG_HOME'}, $project_id);
    my($base_cluster_conf_id) = $form_opt->{'base_cluster_conf_id'};
    if (!$base_cluster_conf_id) {
        $base_cluster_conf_id = get_base_cluster_conf_id($dir_base_cluster);
    }

    my($auth) = RECOG::RecogProject->new();

    #
    my(%spid_hash, %spec_hash);
    my($proj_ref) = $auth->get_project($user, $project_id);
    foreach my$spid (@{$proj_ref->{'PROP'}->{'spid_list'}}) {
        my($spec) = spid2sp($spid);
        $spid_hash{"$spid"} = 1;
        $spec_hash{"$spec"} = 1;
    }

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print qq{<script>this.top.opener.location.reload();</script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Delete base cluster condition</h1>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    #
    File::Path::mkpath("$dir_base_cluster", 0, 0750);
    my($file_conf) = "$dir_base_cluster/$base_cluster_conf_id.conf";
    unlink("$file_conf");

    print qq{<input type="button" name="btn_close" value="Close" onclick="window.close();">};

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id', 'base_cluster_conf_id');
    my(@key_list) = $cgi->param();
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }
    $form_opt->{'species'} = join(',', $cgi->param('species'));

    delete_base_cluster_conf($form_opt);
}

###############################################################################
1;#
###############################################################################
