#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub del_project_domclust {
    my($db) = shift;
    my($uid) = shift;
    my($proj_id) = shift;
    my($clusttabid) = shift;
    my($name) = shift;
    my($opt) = shift;

    if (! defined $proj_id || !$clusttabid || !$name) {
        exit(0);
    }

    my($tab) = "project_domclust";
    my($where) = "proj_id=? and clusttabid=? and name=?";
    my($sql) = "delete from $tab where $where";

    my($sth) = $db->prepare($sql);
    $sth->execute($proj_id, $clusttabid, $name);

    return;
}

###############################################################################
#
sub del_project_phylopat {
    my($db) = shift;
    my($uid) = shift;
    my($proj_id) = shift;
    my($clusttabid) = shift;
    my($phylopatid) = shift;
    my($name) = shift;
    my($opt) = shift;

    if (!defined $proj_id || !$clusttabid || !$phylopatid || !$name) {
        exit(0);
    }

    my($tab) = "project_phylopat";
    my($where) = "proj_id=? and clusttabid=? and phylopatid=? and name=?";
    my($sql) = "delete from $tab where $where";

    my($sth) = $db->prepare($sql);
    $sth->execute($proj_id, $clusttabid, $phylopatid, $name);

    return;
}

###############################################################################
#
sub del_project_core {
    my($db) = shift;
    my($uid) = shift;
    my($proj_id) = shift;
    my($clusttabid) = shift;
    my($coreid) = shift;
    my($name) = shift;
    my($opt) = shift;

    if (!defined $proj_id || !$clusttabid || !$coreid || !$name) {
        exit(0);
    }

    my($tab) = "project_core";
    my($where) = "proj_id=? and clusttabid=? and coreid=? and name=?";
    my($sql) = "delete from $tab where $where";

    my($sth) = $db->prepare($sql);
    $sth->execute($proj_id, $clusttabid, $coreid, $name);

    return;
}

###############################################################################
#
sub delete_project_cluster {
    my($form_opt) = shift;
    my($user_name) = $ENV{'REMOTE_USER'};

    #
    my($dbname) = $main::DBNAME_RECOG;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    #
    my($uid) = RecogProjectCommon::exists_user_name($user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($type)       = $form_opt->{'type'};
    my($proj_id)    = $form_opt->{'proj_id'};
    my($clusttabid) = $form_opt->{'clusttabid'};
    my($phylopatid) = $form_opt->{'phylopatid'};
    my($coreid)     = $form_opt->{'coreid'};
    my($name)       = $form_opt->{'name'};

    #
    if ($type =~ /^domclust$/i) {
        del_project_domclust($db, $uid, $proj_id, $clusttabid, $name, $form_opt);
    }
    elsif ($type =~ /^phylopat$/i) {
        del_project_phylopat($db, $uid, $proj_id, $clusttabid, $phylopatid, $name, $form_opt);
    }
    elsif ($type =~ /^core$/i) {
        del_project_core($db, $uid, $proj_id, $clusttabid, $coreid, $name, $form_opt);
    }
    else {
    }

    #
    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script>
this.top.opener.location.reload();
</script>
</head>
EOB

    #
    print "<body>\n";

    print "<h1>Delete project cluster</h1>\n";
    print "Done.<br />\n";
    print qq{<input type="button" name="btn_close" value="Close" onclick="self.close();">\n};

    print "</body>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('type', 'proj_id', 'clusttabid', 'phylopatid', 'coreid',
                     'name');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    delete_project_cluster($form_opt);
}

###############################################################################
1;#
###############################################################################
