#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;

###############################################################################
sub derive_project {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};
    my($derive_project_id) = $form_opt->{'derive_project_id'};

    #
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys) = $auth->permit_project_user($user,
                                              $RECOG::RecogProject::ID_PRJ_system,
                                              $RECOG::RecogProject::ACT_ADD_PRJ);
    my($sta_prj) = $auth->permit_project_user($user,
                                              $derive_project_id,
                                              $RECOG::RecogProject::ACT_ADD_SUBPRJ);
    if (!$sta_sys && !$sta_prj) {
        $auth->print_html_sorry($user);
        exit();
    }

    #
    my(%derive_proj_spid);
    my($derive_proj_ref) = $auth->get_project($user, $derive_project_id);
    foreach my$spid (@{$derive_proj_ref->{'PROP'}->{'spid_list'}}) {
        $derive_proj_spid{"$spid"} = 1;
    }

    # ȤȤʤäץȤ¸ߤʤʪ拾ɤ
    my($file_spidtab)      = "$ENV{'MBGD_HOME'}/etc/spid.tab";
    my($file_spidtab_dist) = "$file_spidtab.dist";
    my($msg);
    my($id);
    my($project_name) = $form_opt->{'project_name'};
    my($project_descr) = $form_opt->{'project_descr'};
    my(@project_species);
    my(@spec_list) = @{$form_opt->{'project_species'}};
    my($spid);
    foreach my$spec (@spec_list) {
        if ($spec =~ /^g[mu]\d+$/) {
            $spid = $spec;
        }
        else {
            $spid = main::sp2spid($spec, $file_spidtab_dist);
            if (!$spid) {
                $spid = main::sp2spid($spec, $file_spidtab);
            }
        }

        if (!$derive_proj_spid{"$spid"}) {
            next;
        }
        push(@project_species, $spid);
    }

    my($sta) = $auth->exists_project_name($user, $project_name);
    if ($sta) {
        # Found project!
        $msg = "Already exists. [$project_name]";
    }
    else {
        #
        my($opt) = {};
        $opt->{'descr'} = $project_descr;
        $opt->{'derive'} = $derive_project_id;
        my($id_proj) = $auth->derive_project($user, $project_name, $opt);
        $auth->set_project_species($user, $id_proj, @project_species);

        $msg = "Success.";
    }

    print "Content-type: text/html\n";
    print "\n";

    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />\n};
    print <<EOB;
<script>
this.top.opener.location.reload();
</script>
EOB

    print "</htad>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Derive project</h1>\n";
    print $msg;
    print <<EOB;
<form>
<input type="button" name="btn_close" value="Close" onclick="self.close();">
</form>
EOB
    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_name', 'project_descr', 'derive_project_id');
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    my($key) = 'project_species';
    $form_opt->{"$key"} = [];
    push(@{$form_opt->{"$key"}}, $cgi->param($key));

    derive_project($form_opt);
}

###############################################################################
1;#
###############################################################################
