#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;

###############################################################################
sub derive_project_win {
    my($form_opt) = shift;

    my($user) = $ENV{'REMOTE_USER'};
    my($id_proj) = $form_opt->{'project_id'};

    #
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys) = $auth->permit_project_user($user,
                                              $RECOG::RecogProject::ID_PRJ_system,
                                              $RECOG::RecogProject::ACT_ADD_PRJ);
    my($sta_prj) = $auth->permit_project_user($user,
                                              $id_proj,
                                              $RECOG::RecogProject::ACT_ADD_SUBPRJ);
    if (!$sta_sys && !$sta_prj) {
        $auth->print_html_sorry($user);
        exit();
    }

    print "Content-type: text/html\n";
    print "\n";

    print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
</head>

<body>
<div style="float:right; text-align:right;">[ $user ]</div>
<h1>Derive project</h1>
<form name="" method="post" action="/htbin/recog_project/derive_project.cgi">
<input type="hidden" name="derive_project_id" value="$id_proj">
<table border>
<tr><th>Name</th>
    <td><input type="text" name="project_name" value="" size="50">
        <input type="button" name="btn_check_name" value="Check name" onclick="exists_project_name(this.form.project_name.value); ">
    </td>
</tr>

<tr><th>Descr</th>
    <td><input type="text" name="project_descr" value="$form_opt->{'project_descr'}" style="width:100%;"></td>
</tr>

<tr><th>Species</th>
    <td>
EOB

    my($opt) = {};
    $opt->{'derive'} = 1;
    my($proj_ref) = $auth->get_project($user, $id_proj);
    RecogProjectCommon::print_select_project_species($proj_ref, $opt);
    print <<EOB;
    </td>
</tr>

</table>
<input type="button" name="btn_close" value="Close" onclick="window.close();">
<input type="submit" name="btn_derive" value="Derive">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id');
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    derive_project_win($form_opt);
}

###############################################################################
1;#
###############################################################################
