#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use MBGD::Taxonomy;
use SelectByTaxonomy;
use RECOG::RecogProject;
use RecogProjectCommon;
require 'libMBGDaxes.pl';

###############################################################################
sub print_user {
    my($user_ref) = shift;

    print qq{<a href="/htbin/recog_project/view_user.cgi?user_id=$user_ref->{'id'}">$user_ref->{'name'}</a>\n};

    return;
}

###############################################################################
sub edit_project_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys_proj) = $auth->is_system_project($user, $project_id);
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if ($sta_sys_proj) {
        if (!$sta_sysadm) {
            $auth->print_html_sorry($user);
            exit();
        }
    }

    #
    my($proj_ref) = $auth->load_project($user, $project_id);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Edit Project</h1>\n";

    #
    if (!$proj_ref) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    #
    my($proj_ref) = $auth->get_project($user, $project_id);
    my(@spec_list) = $auth->get_spec_list($user, $project_id);
    my($spec_list) = join(',', @spec_list);
    my($n_spec_list) = scalar(@spec_list);
    my(@spec_bc_list) = $auth->get_spec_list_base_cluster($user, $project_id);
    my($spec_bc_list) = join(',', @spec_bc_list);

    #
    my($descr) = $auth->get_project_descr($user, $project_id);
    my($sta) = $auth->get_project_create_default_cluster($user, $project_id);
    my($sta_dc) = '';
    if ($sta =~ /^yes$/i) {
        $sta_dc = 'checked';
    }

    print <<EOB;
<script>
this.top.opener.location.reload();
</script>
<form name="frm_edit_proj_win" method="post" action="/htbin/recog_project/edit_project.cgi">
<table border>
<tr><th>Name</th>
    <td>$proj_ref->{'PROP'}->{'name'}
        <input type="hidden" name="project_id" value="$proj_ref->{'ID'}">
    </td>
</tr>

<tr><th>Descr</th>
    <td><input type="text" name="project_descr" value="$descr" style="width:100%;" size="50"></td>
</tr>

<tr><th>Species</th>
    <td><input type="button" name="btn_taxonomy_tree" value="Select by taxonomy" onclick="select_species_taxonomy_win()">
        <div id="id_species">$n_spec_list species<br />$spec_list</div>
    </td>
</tr>

<tr><th>Base Cluster</th>
    <td><input type="button" name="btn_select_base_cluster" value="Choose base cluster" onclick="select_base_cluster_win()">
        <div id="id_base_cluster"><!-- $spec_bc_list --></div>
    </td>
</tr>

<tr><th>Default cluster</th>
    <td>
        <div id="id_default_cluster"><input type="checkbox" name="create_default_cluster" value="yes" $sta_dc>Create default cluster by selected species</div>
    </td>
</tr>

<tr><th>Member(s)</th>
    <td><input type="button" name="btn_list_member" value="List member(s)" onclick="list_project_user_win(this.form, $proj_ref->{'ID'});"></td>
</tr>

EOB

    my($opt) = {};
    if (!$sta_sysadm) {
        $opt->{'derive'} = $proj_ref->{'PROP'}->{'derive'};
    }
    print "    </table>";

    print <<EOB;
<input type="reset" name="btn_reset" value="Reset">
<input type="button" name="btn_edit" value="Update" onclick="edit_project(this.form);">
<input type="button" name="btn_close" value="Close" onclick="window.close();">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    foreach my$key ('project_id') {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    edit_project_win($form_opt);
}

###############################################################################
1;#
###############################################################################
