#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub get_cluster_prop_type {
    my($ref) = shift;

    #
    my($type_val) = 'c_val';
    if ($ref->{'type'} =~ /^num$/i) {
        $type_val = 'n_val';
    }

    return $type_val;
}

###############################################################################
#
sub print_cluster_prop_head {
    my($prop_name) = shift;
    my($ref) = shift;

    #
    $prop_name .= '(';
    $prop_name .= $ref->{'type'};
    if ($ref->{'elm_ext'}) {
        $prop_name .= "(" . $ref->{'elm_ext'} . ")";
    }
    if ($ref->{'is_multi'}) {
        $prop_name .= ",Multi";
    }
    $prop_name .= ')';

    print join("\t", 'clustid', $prop_name), "\n";

    return;
}

###############################################################################
#
sub print_cluster_prop {
    my($results) = shift;

    my(@id_list) = sort(keys(%{$results}));
    foreach my$id (@id_list) {
        my($cid, $scid) = split(/\:/, $id);
        my($val) = $results->{"$id"};

        my($id) = $cid;
        if ($scid) {
            $id .= ".$scid";
        }
        print join("\t", $id, $val), "\n";
    }

    return;
}

###############################################################################
#
sub get_cluster_prop {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($tabid) = $form_opt->{'tabid'};
    my($prop_name) = $form_opt->{'prop_name'};
    my($cluster_prop_info_ref) = RecogProjectCommon::get_cluster_prop_info($db, $tabid, $prop_name);
    if (!$cluster_prop_info_ref) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($cluster_prop_ref) = {};
    my($tab) = 'cluster_prop';
    my($where) = "tabid=? and prop_name=?";
    my($order) = "clustid, subclustid";
    my($sql) = "select * from $tab where $where order by $order";
    my($sth) = $db->prepare($sql);

    #
    my($type_val) = get_cluster_prop_type($cluster_prop_info_ref);
    my($results) = {};
    $sth->execute($tabid, $prop_name);
    while (my$ref=$sth->fetchrow_hashref()) {
        my($cid)  = $ref->{'clustid'};
        my($scid) = $ref->{'subclustid'};
        if ($results->{"$cid:$scid"} ne '') {
            $results->{"$cid:$scid"} .= ';';
        }
        $results->{"$cid:$scid"} .= $ref->{"$type_val"};
    }

    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);
    print_cluster_prop_head($prop_name, $cluster_prop_info_ref);
    print_cluster_prop($results);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('tabid', 'prop_name');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    get_cluster_prop($form_opt);
}

###############################################################################
1;#
###############################################################################
