#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub list_cluster_set {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        # print no data
        return;
    }

    my($tabid) = $form_opt->{'tabid'};
    my(@cluster_set_list) = RecogProjectCommon::list_cluster_set($db, $tabid);

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);

    #
    print "#", join("\t", 'set_name', 'set_size'), "\n";
    foreach my$ref (@cluster_set_list) {
        print join("\t", $ref->{'set_name'}, $ref->{'set_size'}), "\n";
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('tabid');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    list_cluster_set($form_opt);
}

###############################################################################
1;#
###############################################################################
