#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub list_gene_prop {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        # print no data
        return;
    }

    my(@prop_info_list) = RecogProjectCommon::select_gene_prop_info($db);

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);

    #
    print "#", join("\t", 'prop_name', 'type', 'spec'), "\n";
    foreach my$ref (@prop_info_list) {
        #
        my($prop_name) = $ref->{'prop_name'};
        my($type)      = $ref->{'type'};
        if ($ref->{'elm_ext'}) {
            $type .= "(" . $ref->{'elm_ext'} . ")";
        }
        if ($ref->{'is_multi'}) {
            $type .= ",Multi";
        }

        print join("\t", $prop_name,
                         $type,
                         $ref->{'spec'}), "\n";
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ();
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $form_opt->{"$key"} = $val;
    }

    list_gene_prop($form_opt);
}

###############################################################################
1;#
###############################################################################
