#!/usr/bin/perl -s
use strict;
use CGI;
use MBGD::DB;
use RecogProjectCommon;
use RECOG::RecogProject;
use RECOG::RecogCommon;

###############################################################################
sub print_system_project_html {
    my($ref) = {};

    #
    $ref->{'ID'}   = $RecogProjectCommon::ID_PRJ_SYSTEM;
    $ref->{'NAME'} = $RecogProjectCommon::NAME_PRJ_SYSTEM;

    my($n) = 0;
    print <<EOB;
<tr>
    <td></td>
    <td></td>
    <td><input type="button" name="btn_edit" value="Edit" onclick="edit_project_win($ref->{'ID'});"></td>
    <td></td>
    <td>$ref->{'NAME'}</td>
    <td></td>
    <td align="right">$n</td>
    <td>
    <td>
    <td> <a href="list_project_cluster_win.cgi?proj_id=$ref->{'ID'}">cluster</a>
         <a href="list_project_cluster_win.cgi?proj_id=$ref->{'ID'}&type=core">core</a>
    </td>
</tr>
EOB

    return;
}

###############################################################################
sub get_spid_list {
    my($ref) = shift;

    my($spid_ref) = {};
    $spid_ref->{'spid_list'} = [];
    $spid_ref->{'spid_bc_list'} = [];
    $spid_ref->{'spid_lo_list'} = [];

    #
    push(@{$spid_ref->{'spid_list'}}, @{$ref->{'PROP'}->{'spid_list'}});

    #
    my(%spid_bc_hash);
    if ($ref->{'BASE_CLUSTER'}) {
        push(@{$spid_ref->{'spid_bc_list'}}, @{$ref->{'BASE_CLUSTER'}->{'spid_list'}});
        foreach my$spid (@{$spid_ref->{'spid_bc_list'}}) {
            $spid_bc_hash{"$spid"} = 1;
        }
    }

    #
    foreach my$spid (@{$spid_ref->{'spid_list'}}) {
        next if ($spid_bc_hash{"$spid"});

        push(@{$spid_ref->{'spid_lo_list'}}, $spid);
    }

    return $spid_ref;
}

###############################################################################
sub print_project_html {
    my($ref) = shift;

    my($spid_ref) = get_spid_list($ref);
    my(@spid_list) = @{$spid_ref->{'spid_list'}};
    my(@spid_bc_list) = @{$spid_ref->{'spid_bc_list'}};
    my(@spid_lo_list) = @{$spid_ref->{'spid_lo_list'}};

    #
    my($n) = scalar(@spid_lo_list) + scalar(@spid_bc_list);

    #
    print <<EOB;
<tr>
    <td><input type="button" name="btn_del" value="Del" onclick="delete_project($ref->{'ID'});"></td>
    <td style="text-align: center; ">
EOB

    if (!$ref->{'PROP'}->{'derive'}) {
        print qq{<input type="button" name="btn_derive" value="Derive" onclick="derive_project($ref->{'ID'});">};
    }
    else {
        print $ref->{'PROP'}->{'derive'};
    }

    print <<EOB;
</td>
    <td><input type="button" name="btn_edit" value="Edit" onclick="edit_project_win($ref->{'ID'});"></td>
    <td style="text-align: center; ">$ref->{'ID'}</td>
    <td>$ref->{'PROP'}->{'name'}</td>
    <td>$ref->{'PROP'}->{'descr'}</td>
    <td align="right">$n</td>
    <td>
EOB

    #
    my($dir_etc) = "$ENV{'MBGD_HOME'}/etc";
    my($dir_public_server) = $dir_etc . '/' . $main::NAME_PUBLIC_SERVER;
    my($file_genome) = "$dir_public_server/tab_genome.txt";
    my($tab_genome_pub_ref) = RecogProjectCommon::read_tab_genome($file_genome);
    my($tab_genome_loc_ref) = RecogProjectCommon::read_tab_genome_local();

    #
    my($html_spec_lo) = '';
    my($html_spec_bc) = '';
    foreach my$spid (@spid_bc_list) {
        my($ent) = $tab_genome_pub_ref->{'SPID'}->{"$spid"};
        if ($ent) {
            my($spec) = $ent->{'sp'};
            my($orgname) = $ent->{'orgname'};
            my($strain)  = $ent->{'strain'};
            my($spec_name) = "[$spec] $orgname";
            if ($strain) {
                $spec_name .= "($strain)";
            }
            $html_spec_bc .= qq{<span title="$spec_name">$spec</span>\n};
        } else {
	    my($ent_lo) = $tab_genome_loc_ref->{'SPID'}->{"$spid"};
	    if ($ent_lo) {
		my($spec) = $ent_lo->{'sp'};
		my($orgname) = $ent_lo->{'orgname'};
		my($strain)  = $ent_lo->{'strain'};
		my($spec_name) = "[$spec] $orgname";
		if ($strain) {
		    $spec_name .= "($strain)";
		}
		$html_spec_bc .= qq{<span title="$spec_name">$spec</span>\n};
	    }
	}
	    
    }

    foreach my$spid (@spid_lo_list) {
        my($ent) = $tab_genome_pub_ref->{'SPID'}->{"$spid"};
        if ($ent) {
            my($spec) = $ent->{'sp'};
            my($orgname) = $ent->{'orgname'};
            my($strain)  = $ent->{'strain'};
            my($spec_name) = "[$spec] $orgname";
            if ($strain) {
                $spec_name .= "($strain)";
            }
            $html_spec_lo .= qq{<span title="$spec_name">$spec</span>\n};
        }
        else {
            $ent = $tab_genome_loc_ref->{'SPID'}->{"$spid"};

            my($spec) = $ent->{'sp'};
            my($orgname) = $ent->{'orgname'};
            my($strain)  = $ent->{'strain'};
            my($spec_name) = "[$spec] $orgname";
            if ($strain) {
                $spec_name .= "($strain)";
            }
            $html_spec_lo .= qq{<span title="$spec_name">$spec</span>\n};
        }
    }
    print $html_spec_lo;
    print "</td><td>\n";
    print $html_spec_bc;
    print "</td><td>\n";
    print qq{<a href="list_project_cluster_win.cgi?proj_id=$ref->{'ID'}">cluster</a>\n};
    print qq{<a href="list_project_cluster_win.cgi?proj_id=$ref->{'ID'}&type=core">core</a>\n};
    print "</td>\n";
    print <<EOB;
    </td>
</tr>
EOB

    return;
}

###############################################################################
sub print_project_text {
    my($ref) = shift;
    my($opt_ref) = shift;

    #
    my($id) = $ref->{'ID'};

    my($name) = $ref->{'PROP'}->{'name'};
    $name =~ s#(\W)#sprintf("%%%02X", ord($1))#ge;

    my($descr) = $ref->{'PROP'}->{'descr'};
    $descr =~ s#(\W)#sprintf("%%%02X", ord($1))#ge;

    #
    my($spid_ref) = get_spid_list($ref);

    my($spec) = '';
    my(@spid_list) = @{$spid_ref->{'spid_list'}};

    #
    my($is_public_spec_only) = $opt_ref->{'public_spec_only'};
    my($pub_spec_ref);
    if ($is_public_spec_only) {
        @spid_list = ();
    }
    if ($ref->{'BASE_CLUSTER'}) {
        my(@spid_bc_list) = @{$spid_ref->{'spid_bc_list'}};
        push(@spid_list, @spid_bc_list);
    }

    if (scalar(@spid_list) != 0) {
        my($dir_etc) = "$ENV{'MBGD_HOME'}/etc";
        my($dir_public_server) = $dir_etc . '/' . $main::NAME_PUBLIC_SERVER;
        my($file_genome) = "$dir_public_server/tab_genome.txt";
        my($tab_genome_pub_ref) = RecogProjectCommon::read_tab_genome($file_genome);
        my($tab_genome_loc_ref) = RecogProjectCommon::read_tab_genome_local();
        foreach my$spid (@spid_list) {
            my($ent) = $tab_genome_pub_ref->{'SPID'}->{"$spid"};
            if (!$ent) {
                $ent = $tab_genome_loc_ref->{'SPID'}->{"$spid"};
            }

            my($sp) = $ent->{'sp'};
            if ($pub_spec_ref && !exists($pub_spec_ref->{"$sp"})) {
                next;
            }

            $spec .= ',' if ($spec ne '');
            $spec .= $sp;
        }
    }

    #
    print join("\t", $id, $name, $descr, $spec),"\n";

    return;
}

###############################################################################
sub print_list_project_html {
    my($user) = shift;
    my($auth) = shift;
    my($proj_id) = shift;
    my($opt_ref) = shift;

    print "Content-type: text/html\n";
    print "\n";
    print <<EOB;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
<script>
function update_project_list() {
    var doc = this.document;

    doc.location.reload();

    return;
}

</script>
</head>

<body>
<div style="float:right; text-align:right;">[ $user ]</div>
<h1>List Project(s)</h1>

<form name="frm_create_project" method="post" action="/htbin/recog_project/create_project_win.cgi" target="win_create_project">
<input type="submit" name="btn_create_proj" value="Create new project">
<input type="button" name="btn_update_list" value="Update list" onclick="update_project_list();">
</form>

<form name="frm_edit_project" method="get" action="/htbin/recog_project/edit_project_win.cgi" target="edit_project">
<input type="hidden" name="project_id" value="">
<table border>
<tr><th></th>
    <th></th>
    <th></th>
    <th>ID</th>
    <th>Name</th>
    <th>Descr</th>
    <th>count</th>
    <th>Species</th>
    <th>Species(Base Cluster)</th>
    <th>Project Data</th>
</tr>
EOB

    #
    print_system_project_html();

    #
    my(@id_list) = $auth->get_project_id_list();
    foreach my$id (sort {$a <=> $b} @id_list) {
        next if ($id == $RECOG::RecogProject::ID_PRJ_system);

        my($ref) = $auth->get_project($user, $id);
        print_project_html($ref);
    }

    print <<EOB;
</table>
</form>
<form name="frm_list_base_cluster">
<input type="hidden" name="project_id" value="">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
sub print_list_project_text {
    my($user) = shift;
    my($auth) = shift;
    my($proj_id) = shift;
    my($opt_ref) = shift;

    #
    my($sta_sys) = $auth->permit_project_user($user,
                                              $RECOG::RecogProject::ID_PRJ_system,
                                              $RECOG::RecogProject::ACT_ADD_PRJ);

    #
    print "Content-type: text/plain\n";
    print "\n";

    print '#', join("\t", 'Id', 'Name', 'Descr', 'Spec'), "\n";

    my(@id_list) = $auth->get_project_id_list();
    foreach my$id (sort(@id_list)) {
        next if ($id == $RECOG::RecogProject::ID_PRJ_system);
        if ($proj_id) {
           if ($id != $proj_id) {
               next;
           }
        }

        my($sta_prj) = $auth->permit_project_user($user,
                                                  $id,
                                                  $RECOG::RecogProject::ACT_VIEW_PRJ_DAT);
        if (!$sta_sys && !$sta_prj) {
            next;
        }

        my($ref) = $auth->get_project($user, $id);
        print_project_text($ref, $opt_ref);
    }

    return;
}

###############################################################################
sub list_project {
    my($formOpt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($mode) = $formOpt->{'mode'};
    my($proj_id) = $formOpt->{'id'};

    #
    my($file_tax) = "$ENV{'MBGD_HOME'}/etc/tax";
    RECOG::RecogCommon::update_tax_tree($file_tax);

    #
    my($auth) = RECOG::RecogProject->new();
    if ($mode !~ /^text$/i) {
        print_list_project_html($user, $auth, $proj_id, $formOpt);
    }
    else {
        print_list_project_text($user, $auth, $proj_id, $formOpt);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($formOpt) = {};
    my(@key_list) = ('mode', 'id', 'public_spec_only');
    foreach my$key (@key_list) {
        $formOpt->{"$key"} = $cgi->param($key);
    }
    $formOpt->{'id'} = $cgi->param('project_id');

    list_project($formOpt);
}

###############################################################################
1;#
###############################################################################
