#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub put_cluster_prop {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($tabid) = $form_opt->{'tabid'};

    #
    my($cluster_prop_ref) = RecogProjectCommon::parse_cluster_prop($form_opt->{'prop_val'});

    #
    my($prop_name) = $cluster_prop_ref->{'HEAD'}->{'NAME'};
    my($cluster_prop_info_ref) = RecogProjectCommon::get_cluster_prop_info($db, $tabid, $prop_name);
    my($mode) = $form_opt->{'mode'};
    if (!$mode) {
        if (!$cluster_prop_info_ref) {
            RecogProjectCommon::insert_cluster_prop_info($db, $tabid, $cluster_prop_ref->{'HEAD'});
            RecogProjectCommon::append_cluster_prop($db, $uid, $tabid, $cluster_prop_ref);
        }
        else {
            # already exists ==> ERROR!
            my($sta) = 'error';
            my($msg) = 'already exists';
            RecogProjectCommon::print_status($sta, $msg);
            return;
        }
    }
    else {
        if (!$cluster_prop_info_ref) {
            RecogProjectCommon::insert_cluster_prop_info($db, $tabid, $cluster_prop_ref->{'HEAD'});
        }
        else {
            RecogProjectCommon::update_cluster_prop_info($db, $tabid, $cluster_prop_ref->{'HEAD'});
        }

        if ($mode =~ /^append$/i) {
            RecogProjectCommon::append_cluster_prop($db, $uid, $tabid, $cluster_prop_ref);
        }
        elsif ($mode =~ /^overwrite$/i) {
            RecogProjectCommon::overwrite_cluster_prop($db, $uid, $tabid, $cluster_prop_ref);
        }
        elsif ($mode =~ /^replace$/i) {
            RecogProjectCommon::replace_cluster_prop($db, $uid, $tabid, $cluster_prop_ref);
        }
        else {
        }
    }

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('tabid', 'prop_val', 'mode');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $val =~ s#^\s*##;
        $val =~ s#\s*$##;
        $form_opt->{"$key"} = $val;
    }

    put_cluster_prop($form_opt);
}

###############################################################################
1;#
###############################################################################
