#!/usr/bin/perl -s
use strict;
use CGI;
use IO::File;
use MBGD::DB;
use RecogProjectCommon;

###############################################################################
#
sub put_gene_prop {
    my($form_opt) = shift;

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::DBNAME) {
        $dbname = $main::DBNAME;
    }
    my($db) = MBGD::DB->new($dbname);

    my($user_name) = $ENV{'REMOTE_USER'};
    my($uid) = RecogProjectCommon::exists_user_name($db, $user_name);
    if (!$uid) {
        my($sta) = 'ok';
        RecogProjectCommon::print_status($sta);
        return;
    }

    #
    my($gene_prop_ref) = RecogProjectCommon::parse_gene_prop($form_opt->{'prop_val'});

    #
    my($prop_name) = $gene_prop_ref->{'HEAD'}->{'NAME'};
    if ($prop_name =~ /^\s*$/) {
        # No prop_name ==> ERROR!
        my($sta) = 'error';
        my($msg) = 'Cna not found property name.';
        RecogProjectCommon::print_status($sta, $msg);
        return;
    }

    my($gene_prop_info_ref) = RecogProjectCommon::get_gene_prop_info($db, $prop_name);
    my($mode) = $form_opt->{'mode'};
    if (!$mode) {
        if (!$gene_prop_info_ref) {
            RecogProjectCommon::insert_gene_prop_info($db, $gene_prop_ref->{'HEAD'});
            RecogProjectCommon::append_gene_prop($db, $uid, $gene_prop_ref);
        }
        else {
            # already exists ==> ERROR!
            my($sta) = 'error';
            my($msg) = 'already exists';
            RecogProjectCommon::print_status($sta, $msg);
            return;
        }
    }
    else {
        if (!$gene_prop_info_ref) {
            RecogProjectCommon::insert_gene_prop_info($db, $gene_prop_ref->{'HEAD'});
        }
        else {
            RecogProjectCommon::update_gene_prop_info($db, $gene_prop_ref->{'HEAD'});
        }

        if ($mode =~ /^append$/i) {
            RecogProjectCommon::append_gene_prop($db, $uid, $gene_prop_ref);
        }
        elsif ($mode =~ /^overwrite$/i) {
            RecogProjectCommon::overwrite_gene_prop($db, $uid, $gene_prop_ref);
        }
        elsif ($mode =~ /^replace$/i) {
            RecogProjectCommon::replace_gene_prop($db, $uid, $gene_prop_ref);
        }
        else {
        }
    }

    #
    my($sta) = 'ok';
    RecogProjectCommon::print_status($sta);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('prop_val', 'mode');
    foreach my$key (@key_list) {
        my($val) = $cgi->param($key);
        $val =~ s#^\s*##;
        $val =~ s#\s*$##;
        $form_opt->{"$key"} = $val;
    }

    put_gene_prop($form_opt);
}

###############################################################################
1;#
###############################################################################
