#!/usr/bin/perl -s
use strict;
use CGI;
use IO::Dir;
use IO::File;
use MBGD::DB;
use MBGD::Taxonomy;
use SelectByTaxonomy;
use RecogProjectCommon;
require 'InfoSpec.pl';

###############################################################################
#
sub select_spec_taxonomy_win {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys_proj) = $auth->is_system_project($user, $project_id);
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if ($sta_sys_proj) {
        if (!$sta_sysadm) {
            $auth->print_html_sorry($user);
            exit();
        }
    }

    #
    my($proj_ref) = $auth->get_project($user, $project_id);
    my(@spec_list) = $auth->get_spec_list($user, $project_id);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print "<html>\n";
    print "<head>\n";
    print qq{<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />};
    print qq{<script language="JavaScript" src="/js/recog_project.js"></script>};
    print qq{<script language="JavaScript" src="/js/mbgd.js"></script>\n};
    print qq{<script language="JavaScript" src="/js/create_tax.js"></script>\n};
    print qq{<script language="JavaScript">\n};
    print qq{cluster_maxsp = 100;\n};
    print qq{default_orgs = '';\n};
    print qq{\n};
    print<<EOB;
function doClose() {
    this.close();
    return;
}
EOB
    print qq{</script>\n};
    print "</head>\n";
    print "<body>\n";

    print qq{<form name="specForm" method="post" action="/htbin/recog_project/edit_project.cgi">\n};

    print<<EOB;
<input type="hidden" name="sta_login_mymbgd" value="">
<input type="hidden" name="project_id" value="$project_id">
<INPUT TYPE="button"  VALUE="Clear All" onClick="selectAll(document,0,0,0);">
<input id="cb_choose_one_genome" type="checkbox" name="choose_one_genome" value="yes" checked>Choose one genome for each <SELECT NAME="rank" onChange="elimNonDefault(document);">
<OPTION VALUE="strain" >strain
<OPTION VALUE="species" SELECTED>species

<OPTION VALUE="genus" >genus
<OPTION VALUE="family" >family
<OPTION VALUE="order" >order
<OPTION VALUE="class" >class
<OPTION VALUE="phylum" >phylum
</SELECT>
<INPUT TYPE="button"  VALUE="Select all" onClick="selectAll(document,0,0,1);">
<br>
<INPUT TYPE="button"  VALUE="Count checked taxa" onclick="doCountCheckedTaxa();">
<INPUT TYPE="button"  VALUE="Choose checked taxa" onclick="doSubmit();">
<INPUT TYPE="button"  VALUE="Close" onclick="doClose();">
EOB

    print qq{<div style="width:100%; height: 90%; overflow: scroll;">\n};

#    my($file_tax) = "$ENV{'RECOG_HOME'}/etc/mbgd.genome.ad.jp/tax";
    my($file_tax) = "$ENV{'RECOG_HOME'}/etc/tax";
    if (-e $file_tax) {
        my($tax) = MBGD::Taxonomy->new("$ENV{'MBGD_HOME'}/etc", use_spweight_file=>1);
        $tax->clear_cache();
        $tax->read_taxfile($file_tax);

        #
        my($opt) = {};
        $opt->{'species'} = join(',', @spec_list);
        print_html_organism_selection_taxonomy($tax, 'mbgd', $opt);
    }

    print qq{</div>\n};

    print "</form>\n";

    print "</body>\n";
    print "</html>\n";

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my($form_opt) = {};
    my(@key_list) = ('project_id');
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }

    select_spec_taxonomy_win($form_opt);
}


###############################################################################
1;#
###############################################################################
