#!/usr/bin/perl -s
use strict;
use CGI;
use File::Path;
use RecogProjectCommon;
use RECOG::DomClustCommon;

###############################################################################
#
sub upd_cluster_name {
    my($form_opt) = shift;
    my($user) = $ENV{'REMOTE_USER'};

    #
    my($project_id) = $form_opt->{'project_id'};
    my($auth) = RECOG::RecogProject->new();

    #
    my($sta_sys_proj) = $auth->is_system_project($user, $project_id);
    my($sta_sysadm) = $auth->permit_project_user($user,
                                                 $RECOG::RecogProject::ID_PRJ_system,
                                                 $RECOG::RecogProject::ACT_ADD_USR);
    if ($sta_sys_proj) {
        if (!$sta_sysadm) {
            $auth->print_html_sorry($user);
            exit();
        }
    }

    #
    my($cluster_id)   = $form_opt->{'cluster_id'};
    my($cluster_name) = $form_opt->{'cluster_name'};

    my($dbname) = $main::DBNAME_RECOG;
    my($db) = MBGD::DB->new($dbname);
    my($tab) = 'project_domclust';
    my($where) = "proj_id=$project_id and clusttabid='$cluster_id'";
    my($sql) = "select * from $tab where $where";
    my($sth) = $db->execute($sql);
    my($n_rows) = $sth->rows();
    if ($n_rows == 0) {
        $sql = "insert $tab (proj_id, clusttabid, name) values($project_id, '$cluster_id', '$cluster_name')";
    }
    else {
        $sql = "update $tab set name='$cluster_name' where $where";
    }
    $db->execute($sql);

    #
#    my($proj_ref) = $auth->load_project($user, $project_id);

    #
    print "Content-type: text/html\n";
    print "\n";

    #
    print <<EOS;
<html>
<head>
<link rel="stylesheet" type="text/css" href="/css/mbgd.css" />
<script language="JavaScript" src="/js/recog_project.js"></script>
<script>
this.top.opener.change_server();
</script>
EOS
    print "</head>\n";
    print "<body>\n";
    print qq{<div style="float:right; text-align:right;">[ $user ]</div>\n};
    print "<h1>Update cluster_name</h1>\n";

    print <<EOB;
Done.
<input type="button" name="btn_close" value="Close" onclick="self.close();">
EOB

    #
    my(@cluster_list) = get_cluster_local($cluster_id, $project_id);
    if (scalar(@cluster_list) == 0) {
        print "Sorry, found no project.";
        print "</body>\n";
        print "</html>\n";

        return;
    }

    #
    my$cluster_ref = shift(@cluster_list);
    my($cluster_name) = $cluster_ref->{'CLUSTER_ID'};
    if ($cluster_ref->{'CLUSTER_NAME'} ne '') {
        $cluster_name = $cluster_ref->{'CLUSTER_NAME'}
                      . '('
                      . $cluster_ref->{'CLUSTER_ID'}
                      . ')';
    }


    print <<EOB;
<input type="button" name="btn_close" value="Close" onclick="self.close();">
<input type="button" name="btn_update" value="Update" onclick="upd_cluster_name();">
<table border>
<tr><th>Cluster</th>
    <td>$cluster_name</td>
</tr>
<tr><th>Date</th>
    <td>$cluster_ref->{'DATE'}</td>
</tr>
<tr><th>Options</th>
    <td>$cluster_ref->{'OPTIONS'}</td>
</tr>
<tr><th>Species</th>
    <td>$cluster_ref->{'SPECIES'}</td>
</tr>
EOB

    #
    my$name_ref = shift @{$cluster_ref->{'NAME'}};
    print <<EOB;
<tr><th>Name</th>
    <td><input type="text" name="cluster_name" value="$name_ref->{'name'}"></td>
</tr>
EOB

    print <<EOB;
</table>
<input type="hidden" name="project_id" value="$project_id">
</form>
</body>
</html>
EOB

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($cgi) = CGI->new();

    my(@key_list) = ( 'project_id',
                      'cluster_id',
                      'cluster_name',
                    );
    my($form_opt) = {};
    foreach my$key (@key_list) {
        $form_opt->{"$key"} = $cgi->param($key);
    }
    upd_cluster_name($form_opt);
}
###############################################################################
1;#
###############################################################################
