function isUserGenome(spec) {
    if (spec.search(/^ug[0-9]+$/i) == 0) {
        return true;
    }
    return false;
}
function isContainUserGenome(spec) {
    var splist = spec.split(",");
    var i;

    for(i in splist) {
        var sp = splist[i];
        sta = isUserGenome(sp);
        if (sta) {
            return true;
        }
    }
    return false;
}

function validateMailAddressAtom(adrs, doalert) {
    if (adrs == '') {
        if (doalert) {
            alert('Found blank part');
        }
        return false;
    }

    // invalid characters
    //     0x00-0x1f
    //     space
    //     ()<>@,;:\".[]
    var ret = adrs.match(/[\x00-\x1f \(\)\<\>\@\,\;\:\\\"\.\[\]]/);
    if (ret) {
        if (doalert) {
            alert('Found invalid character :: ' + ret);
        }
        return false;
    }

    // append
    var ret = adrs.match(/[\'\$\&\!\`\*\?\~\/\|]/);
    if (ret) {
        if (doalert) {
            alert('Found invalid character :: ' + ret);
        }
        return false;
    }
    return true;
}

function validateMailAddress(adrs, doalert) {
    var idx;
    var i;

    var nd = adrs.split('@');
    if (nd.length != 2) {
        if (doalert) {
            alert('Please input a \'@\' character');
        }
        return false;
    }

    for(idx = 0; idx < nd.length; idx++) {
        var atoms = nd[idx].split('.');
        if ((idx != 0) && (atoms.length < 2)) {
            if (doalert) {
                alert('Invalid domain');
            }
            return false;
        }
        for(i = 0; i < atoms.length; i++) {
            var atom = atoms[i];
            ret = validateMailAddressAtom(atom, doalert);
            if (! ret) {
                if (doalert) {
                    if (idx == 0) {
//                        alert('Invalid name(E-mail)');
                    }
                    else {
//                        alert('Invalid domain(E-mail)');
                    }
                }
                return false;
            }
        }
    }

    var ret = adrs.match(/^\-/);
    if (ret) {
        if (doalert) {
            alert('Can not start with \'-\'');
        }
        return false;
    }

    return true;
}

function add_event_listener(elm, event_type, func_name, phase) {
  if (!elm) {
    return false;
  }

  if (phase != true) {
    phase = false;
  }
  if (elm.addEventListener) {
      elm.addEventListener(event_type, func_name, phase);
  }
  else if (elm.attachEvent) {
      elm.attachEvent('on' + event_type, func_name);
  }
  else {
    return false;
  }

  return true;
}

function get_event_x(event) {
  if (event.x) {
    return event.x;
  }
  else if (event.pageX) {
    return event.pageX;
  }
  return 0;
}

function get_event_y(event) {
  if (document.all) {
    if (0 < document.body.scrollTop) {
      return event.y + document.body.scrollTop;
    }
    return event.y + document.documentElement.scrollTop;
  }
  else if (event.pageY) {
    return event.pageY;
  }
  return 0;
}

function get_event_x_elm(event) {
  if (event.offsetX) {
    return event.offsetX;
  }
  if (event.target.x) {
    return event.pageX - event.target.x;
  }
}

function get_event_y_elm(event) {
  if (event.offsetY) {
    return event.offsetY;
  }
  if (event.target.y) {
    return event.pageY - event.target.y;
  }
}

