#!/usr/bin/perl -s
use strict;
use MBGD::DB;

###############################################################################
#
sub print_usage {

    print STDERR "Usage :: $0 [-pattern=PATTERN] [-mode=MODE] [dbname1]\n";

    return;
}

###############################################################################
#
sub repair_tables {
    my($dbname, $mode) = @_;

    my($db) = MBGD::DB->new($dbname);
    my($sta) = $db->sta_connect();
    if (!$sta) {
        return;
    }

    my(@tab_list) = $db->list_tables();
    foreach my$tab (@tab_list) {
        my($sql);
	if ($mode ne 'repair_all')  {
		$sql = "check table $tab";
        	my($sth) = $db->execute($sql);
		if ($mode eq 'check') {
			## check only
			my(@a) = $sth->fetchrow_array;
			print STDERR "@a\n";
		        print STDERR "LOG :: $sql :: done\n";
			next;
		} else {
			my($h) = $sth->fetchrow_hashref;
			if ($h->{Msg_type} eq 'status' && $h->{Msg_text} eq 'OK') {
				## status eq OK;
		        	print STDERR "LOG :: $sql :: status OK\n";
				next;
			} else {
				print STDERR ">>>$h->{Msg_type}: $h->{Msg_text}\n";
			}
		}
	}

	$sql = "repair table $tab";
        print STDERR "LOG :: $sql :: start\n";
        my($sth) = $db->execute($sql);
	my(@a) = $sth->fetchrow_array;
	print STDERR "@a\n";
        print STDERR "LOG :: $sql :: done\n";
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    if ($::pattern) {
	my($flag);
	open(P, "mysqlshow|");
	while(<P>) {
		if (! $flag && /^ *\|   *Databases /) {
			$flag = 1;
			next;
		} elsif (/^ *\| *(\S+)/) {
			my($dbname) = $1;
			if ($dbname =~ /$::pattern/) {
	       			repair_tables($dbname, $::mode);
			}
		}
	}
	close(P);
    } else {
    	foreach my$dbname (@ARGV) {
       		repair_tables($dbname, $::mode);
	}
    }
}

###############################################################################
1;#
###############################################################################
