#!/usr/bin/perl -s
use strict;
use FileHandle;
#use GDBM_File;

# "$sp1:$name1", "$sp2:$name2", $from1, $to1, $from2, $to2, $ident, $eval, $score, $pam
$main::PACK_TEMPL = "a38 a38 S S S S f f f f";
if ($main::A30) {
    $main::PACK_TEMPL = "a30 a30 S S S S f f f f";
}

###############################################################################
#
sub unpackBlastdpres {
    my($file) = shift;
    my($pos1) = shift;
    my($pos2) = shift;
    local(*FH);

    my($pd) = pack($main::PACK_TEMPL, 'A', 'B', 1, 2, 3, 4, 5, 6, 7, 8);
    my($sizePd) = length($pd);

    open(FH, "$file") || die("Can not open $file($!)");
    my($buf);
    if (defined($pos1)) {
        seek(FH, $pos1, 0);
    }
    while(read(FH, $buf, $sizePd)) {
        my(@res) = unpack($main::PACK_TEMPL, $buf);
        $res[0] =~ s#\x0##g;
        $res[1] =~ s#\x0##g;
        print "@res\n";

        my($pos) = tell(FH);
        if ($pos2 && ($pos2 <= $pos)) {
            last;
        }
    }
    close(FH);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    if ($main::SPEC) {

        eval "use GDBM_File;";
        my($dir) = "$ENV{'MBGD_HOME'}/database/bldp";
        if ($main::DIR) {
            $dir = $main::DIR;
        }

        #
        my(%Hash);
        my($file_spindex) = "$dir/spindex";
        if (! -e $file_spindex) {
            die("Can not found $file_spindex");
        }

        #
        tie(%Hash, 'GDBM_File', $file_spindex, &GDBM_READER, 0440);

        my(@spec_list) = sort(split(/,/, $main::SPEC));
        foreach my$sp1 (@spec_list) {
            foreach my$sp2 (@spec_list) {
                next if ($sp1 gt $sp2);

                my($key) = "$sp1:$sp2";
                my($val) = $Hash{"$key"};
                my($f, $pos_start, $pos_end) = split(/\:/, $val);
                unpackBlastdpres("$dir/$f", $pos_start, $pos_end);
            }
        }
        untie(%Hash);
    }
    else {
        foreach my$f (@ARGV) {
            unpackBlastdpres($f);
        }
    }
}

###############################################################################
1;#
#
###############################################################################
