#!/usr/bin/perl -s
use strict;
use DirHandle;
use FileHandle;
use File::Basename;
use File::Path;
use POSIX "sys_wait_h";
require "MBGD_Conf.pl";

$main::PACK_TEMPL38 = "a38 a38 S S S S f f f f";
$main::Prefix = "blastdpres";
$main::Suffix = "pack";

###############################################################################
#
sub print_usage {
    print STDERR "Usage :: $0 [-FILE_IN=file_in]\n";
    print STDERR "\n";

    return;
}

###############################################################################
#
sub convert_bldp_sppair {
    my($file_in) = shift;
    my($dir) = shift;
    my($prefix) = shift;

    my($cmd) = "$main::CMD_sort -t ' ' -k 1,1 -k 6,6 $file_in";
    my($fhi) = FileHandle->new("$cmd|") || die("Can't open $cmd($!)");
    my($fho);
    my($prev_sp1, $prev_sp2);
    my(%sta_sppair);
    while(my$line=$fhi->getline()) {
        $line =~ s#[\r\n]*$##;
        my($sp1, $name1, $spname1, $from1, $to1,
           $sp2, $name2, $spname2, $from2, $to2,
           $ident, $eval, $pam, $score) = split(/\t/, $line);

        if ( ($sp1 cmp $sp2) > 0) {
            swap(\$sp1,     \$sp2);
            swap(\$name1,   \$name2);
            swap(\$spname1, \$spname2);
            swap(\$from1,   \$from2);
            swap(\$to1,     \$to2);
        }
        if (($prev_sp1 ne $sp1) && ($prev_sp2 ne $sp2)) {
            if ($fho) {
                $fho->close();
            }

            my($fname) = "$dir/$prefix.$sp1-$sp2";
            if (!exists($sta_sppair{"$sp1:$sp2"})) {
                $fho = FileHandle->new(">$fname")
            }
            else {
                $fho = FileHandle->new(">>$fname")
            }
            if (!$fho) {
                die("Can not open $fname($!)");
            }
            $sta_sppair{"$sp1:$sp2"} = 1;
        }

        $fho->print(join(' ', "$sp1:$name1", "$sp2:$name2",
                              $from1, $to1, $from2, $to2,
                              $ident, $eval, $score, $pam), "\n");
        $prev_sp1 = $sp1;
        $prev_sp2 = $sp2;
    }
    if ($fho) {
        $fho->close();
    }
    $fhi->close();

    #
    my(@sppari_list) = sort(keys(%sta_sppair));
    foreach my$sppair (@sppari_list) {
        my($sp1, $sp2) = split(':', $sppair);
        my($fname) = "$dir/$prefix.$sp1-$sp2";
        my($cmd) = "$main::CMD_sort $fname | $main::CMD_uniq";
        my($fhr) = File::Handle->new("$cmd|") || die("Can not open $cmd($!)");
        my($fhw) = File::Handle->new(">$fname.pack") || die("Can not open $fname.pack($!)");
        while (my$line=$fhr->getline()) {
            $line =~ s#[\r\n]*$##;
            my($dpack) = pack($main::PACK_TEMPL38, split(' ', $line));
            $fhw->print($dpack);
        }
        $fhw->close();
        $fhr->close();

        unlink($fname);
    }

    return;
}

###############################################################################
#
sub swap {
    my($a, $b) = @_;
    my($tmp);
    $tmp = $$a; $$a=$$b; $$b=$tmp;
}

###############################################################################
if ($0 eq __FILE__) {

    my($prefix)    = 'blastdpres';
    my($dir) = "$ENV{'MBGD_HOME'}/database.work/bldp";
    mkpath($dir, 0, 0750);
    if ($main::FILE_IN && -e "$main::FILE_IN") {
        convert_bldp_sppair($main::FILE_IN, $dir, $prefix);
    }
}

###############################################################################
1;#
###############################################################################
