#!/usr/bin/perl -s
use strict;
use IO::Dir;
use IO::File;

###############################################################################
#
sub read_spidtab {
    my($file_spidtab) = shift;

    #
    my($ref) = {};

    my($fh) = IO::File->new("$file_spidtab");
    while (my$line=$fh->getline()) {
        next if ($line =~ /^\s*#/);
        next if ($line =~ /^\s*$/);

        $line =~ s#[\r\n]*$##;

        my($name, $splist) = split(/\t/, $line);
        $ref->{"$name"} = $splist;
    }
    $fh->close();

    return $ref;
}

###############################################################################
#
sub conv_spidtab2proj {

    #
    my($dir_etc) = "$ENV{'RECOG_HOME'}/etc";
    my($dir_spid) = "$dir_etc/spid_set";
    my($file_spid) = "$dir_spid/spid_set.tab";
    if (! -e $file_spid) {
        return;
    }
    print STDERR "Found :: $file_spid\n";
    print STDERR "Converting...\n";
    my($spid_ref) = read_spidtab($file_spid);

    #
    my($idx_proj) = 2;
    my($dir_proj) = "$dir_etc/projects";
    my($dh) = IO::Dir->new("$dir_proj");
    if (!$dh) {
        print STDERR "Can not open $dir_proj($!)\n";
        return;
    }
    while (my$file=$dh->read()) {
        next if ($file =~ /\./);

        my($id_proj) = 1;
        if ($file !~ /system/) {
            $id_proj = $idx_proj++;
        }

        my($fh) = IO::File->new(">>$dir_proj/$file");
        my($splist) = $spid_ref->{"$file"};
        $fh->print('#name', "\t", $file, "\n");
        $fh->print('#spid', "\t", $splist, "\n");
        $fh->close();

        rename("$dir_proj/$file", "$dir_proj/$id_proj");

        delete($spid_ref->{"$file"});
    }

    #
    my(@name_proj_list) = keys(%{$spid_ref});
    foreach my$name (@name_proj_list) {
        print STDERR "WARNING :: Can not found project-file for $name\n";

        my($splist) = $spid_ref->{"$name"};

        my($filename) = "$dir_proj/$idx_proj";
        my($fh) = IO::File->new(">$filename");
        $fh->print('#name', "\t", $name, "\n");
        $fh->print('#spid', "\t", $splist, "\n");
        $fh->print('recogadm', "\t", 'auth_sys_add_data,auth_sys_admin', "\n");
        $fh->close();

        $idx_proj++;
    }
    unlink("$file_spid.bak") if (-e "$file_spid.bak");
    rename("$file_spid", "$file_spid.bak");

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    #
    conv_spidtab2proj();
}

1;#
