#!/usr/bin/perl -s
use strict;
use MBGD::DB;

#
$main::MAX_tabext = 99;

###############################################################################
#
sub printUsage {
    print "Usage :: $0 [-recreate] [-delete] [-mymbgd] DB_NAME\n";
    print "    If homology table exists, this program does nothing. \n";
    print "        -recreate  :: drop and create homology table.\n";
    print "        -delete    :: ONLY drop homology table.\n";
    print "        -mymbgd    :: create homology table for MyMBGD.\n";
    print "        -N_EXT     :: number of mapped homology table.(1-)\n";
    print "\n";
    print "\n";
}

###############################################################################
#
sub getTabExt {
    my($idx) = shift;

    my($ext) = sprintf("%02d", $idx);

    return $ext;
}

###############################################################################
#
sub getTabName {
    my($idx) = shift;

    my($name) = $main::TABLENAME;
    my($ext) = getTabExt($idx);

    $name .= "_$ext";

    return $name;
}

###############################################################################
#
sub dropHomologyTable {
    my($db) = shift;
    my($tab);
    my($opt) = {};

    #
    print STDERR "drop table $main::TABLENAME;\n" if ($main::DEBUG);
    $tab = new MBGD::DBTable($db, $main::TABLENAME);
    $tab->drop_table();

    #
    foreach my$i (0 .. $main::MAX_tabext) {
        my($tabname) = getTabName($i);
        print STDERR "drop table $tabname;\n" if ($main::DEBUG);

        $opt->{'tablename'} = lc($tabname);
        $tab = new MBGD::DBTable($db, $main::TABLENAME, $opt);
        $tab->drop_table();
    }

    # for MyMBGD
    my($tabname) = $main::TABLENAME . '_user';
    $opt->{'tablename'} = lc($tabname);
    $tab = new MBGD::DBTable($db, $main::TABLENAME, $opt);
    $tab->drop_table();

}

###############################################################################
#
sub createHomologyTable {
    my($db) = shift;
    my($maxIdx) = shift;
    my($tab);
    my($opt);

    my(@tabNameList);
    $opt = {};
    foreach my$i (0 .. $maxIdx) {
        my($tabname) = getTabName($i);
        if (! $db->exist_table($tabname)) {
            print STDERR "create table $tabname;\n" if ($main::DEBUG);
            $opt->{'tablename'} = lc($tabname);
#            $tab = new MBGD::DBTable($db, $main::TABLENAME, $opt);
$tab = $db->get_table($main::TABLENAME, {mode=>'write', create=>1, tablename=>lc($tabname)});
            $tab->create_table();
        }
        push(@tabNameList, lc($tabname));
    }

    #
    if ($main::mymbgd) {
        # for MyMBGD
        my($tabname) = $main::TABLENAME . '_user';
        $opt->{'tablename'} = lc($tabname);
        push(@tabNameList, lc($tabname));

        print STDERR "create table $tabname;\n" if ($main::DEBUG);
        $tab = new MBGD::DBTable($db, $main::TABLENAME, $opt);
        $tab->create_table();
    }

    $opt = {};
    my($tabMerge) = join(',', @tabNameList);
    $opt->{'merge_table'} = sprintf("type=merge union=(%s) insert_method=last", $tabMerge);
    $tab = new MBGD::DBTable($db, $main::TABLENAME, $opt);
    $tab->create_table($opt);
}

###############################################################################
if ($0 eq __FILE__) {
    my($dbname) = shift(@ARGV);
    if (! $dbname) {
        print STDERR "ERROR :: No database\n";
        printUsage();
        exit(0);
    }

    #
    $main::TABLENAME = 'Homology' if (! $main::TABLENAME);

    my($db) = new MBGD::DB($dbname);
    if ($db->{'conn'} =~ /^\s*$/) {
        print "Can not connect database. [$dbname]\n";
        exit(-1);
    }
    print STDERR "DBG :: $db->{'conn'};\n" if ($main::DEBUG);

    if ($main::recreate || $main::delete) {
        dropHomologyTable($db);
        exit(0) if ($main::delete);
    }

    #
    if ($main::N_EXT < 1) {
        print STDERR "ERROR :: Bad option : -N_EXT=$main::N_EXT\n";
        printUsage();
        exit(0);
    }
    createHomologyTable($db, $main::N_EXT - 1);

}

1;#
