#!/usr/bin/perl -s
use strict;
use File::Path;
use RecogBuild;
require "MBGD_Conf.pl";

###############################################################################
#
sub update_public_spec_list {

    #
    my($dir_etc) = "$ENV{'MBGD_HOME'}/etc";
    my($dir_public_server) = $dir_etc . '/' . $main::NAME_PUBLIC_SERVER;
    File::Path::mkpath($dir_public_server, 0, 0750);

    #
    my($uri) = $main::URL_PUBLIC_SERVER . '/data/spid.tab.dist';
    my($file_spid_dist) = "$dir_public_server/spid.tab.dist";
    my($cmd) = "$main::CMD_curl -L '$uri' > $file_spid_dist";
    system("$cmd");
    unlink("$dir_etc/spid.tab.dist");
    symlink($file_spid_dist, "$dir_etc/spid.tab.dist");

    # download udate file
    my($uri) = $main::URL_PUBLIC_SERVER . '/data/spec_weight';
    my($file_spec_weight) = "$dir_public_server/spec_weight";
    my($link_spec_weight) = "$dir_etc/spec_weight";
    my($cmd) = "$main::CMD_curl -L '$uri' > $file_spec_weight";
    system("$cmd");
    unlink("$link_spec_weight");
    symlink($file_spec_weight, "$link_spec_weight");

    #
    my($uri) = $main::URL_PUBLIC_SERVER . '/htbin/getData?table=genome&no_header=1';
    my($file_genome) = "$dir_public_server/tab_genome.txt";
    my($cmd) = "$main::CMD_curl -L '$uri' > $file_genome";
    system("$cmd");

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    update_public_spec_list();
}

###############################################################################
1;#
###############################################################################
