#!/usr/bin/perl -s
use strict;
use DirHandle;
use File::Path;
use FileHandle;
require "MBGD_Conf.pl";

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 [-DIR=dir] FILE_taxondump.tar.gz\n";
}

###############################################################################
#
sub convTaxonomyDb {
    my($dir) = shift;
    my($fileTaxdump) = shift;
    my($cmd);

    #
    chdir($dir);

    #
#    if ($main::DOWNLOAD) {
        $fileTaxdump = "$dir/taxdump.tar.gz";
        if (-e "$fileTaxdump") {
            $cmd = "$main::CMD_cp -p $fileTaxdump $fileTaxdump.bak";
            system("$cmd");
        } else {
            new FileHandle(">$fileTaxdump.bak");
        }

        print STDERR "Download :: taxdump.tar.gz\n";
        my($url) = "ftp://ftp.ncbi.nih.gov/pub/taxonomy/taxdump.tar.gz";
        my($proxy);
        if ($ENV{'http_proxy'}) {
            $proxy = "--proxy $ENV{'http_proxy'}";
        }
        $cmd = "$main::CMD_curl $proxy -L -O $url";
        system("$cmd");

        #
        $cmd = "$main::CMD_cmp -s $fileTaxdump $fileTaxdump.bak";
        my$sta = system("$cmd");
        unlink("$fileTaxdump.bak") if (-e "$fileTaxdump.bak");
        if (($sta >> 8) == 0) {
            print "Found no changes.\n";
            if (! $main::force) {
                # ⡼ɤǤϤʤ
                exit(0);
            }
        }
#    }

    #
    print STDERR "Decompress :: taxdump.tar.gz\n";
    $cmd = "$main::CMD_gzip -dc $fileTaxdump | (cd $dir; $main::CMD_tar xf -)";
    system("$cmd");

    #
    my($fileTax) = "taxon.tab";
    my($fileNew) = "taxon.tab.$$";
    print STDERR "Convert :: taxdump.tar.gz\n";
    $cmd = "$main::DIR_build/convTaxonomyDb.pl -DIRNAME=$dir | $main::CMD_sort -t'\t' -k8n > $dir/$fileNew";
    system("$cmd");

    if (($? >> 8) == 0) {
        unlink("$dir/$fileTax") if (-e "$dir/$fileTax");
        rename("$dir/$fileNew", "$dir/$fileTax");

        #
        $cmd = "$main::CMD_cp -p $dir/$fileTax $ENV{'MBGD_HOME'}/etc/";
        system("$cmd");
    }

    #
    my($dh) = new DirHandle("$dir") || die("Can not open $dir($!)");
    foreach my$file ($dh->read()) {
        unlink("$dir/$file") if ($file =~ /\.dmp$/);
        unlink("$dir/$file") if ($file =~ /^readme\.txt$/);
        unlink("$dir/$file") if ($file =~ /^gc\.prt$/);
    }

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dir) = $main::DIR;
    if (! $main::DIR) {
        $dir = $main::DIR_db_taxonomy;
    }
    mkpath($dir, 0, 0750) if (! -e "$dir");

    my($fileTaxdump) = shift(@ARGV);
#    if (! $main::DOWNLOAD && ! $fileTaxdump && ! -e "$fileTaxdump") {
#        printUsage();
#        exit(0);
#    }

    convTaxonomyDb($dir, $fileTaxdump);
}

1;#
