#!/usr/bin/perl -s
use strict;
use DirHandle;
use File::Path;
use FileHandle;
use MBGD::DB;
require "MBGD_common.pl";

###############################################################################
#
sub printUsage {
    print STDERR "Usage :: $0 [-DIR=dir] FILE_cddid.tbl.gz\n";
}

###############################################################################
#
sub createMotif {
    my($dir) = shift;
    my($fileCddId) = shift;
    my($cmd);

    #
    chdir($dir);

    #
    if ($main::DOWNLOAD) {
        $fileCddId = "$dir/cddid.tbl.gz";
        if (-e "$fileCddId") {
            $cmd = "$main::CMD_cp -p $fileCddId $fileCddId.bak";
            system("$cmd");
        } else {
            new FileHandle(">$fileCddId.bak");
        }

        print STDERR "Download :: cddid.tbl.gz\n";
        my($url) = "ftp://ftp.ncbi.nih.gov/pub/mmdb/cdd/cddid.tbl.gz";
        $cmd = "$main::CMD_curl -L -O $url";
        system("$cmd");

        #
        $cmd = "$main::CMD_cmp -s $fileCddId $fileCddId.bak";
        my$sta = system("$cmd");
        if (($sta >> 8) == 0) {
            print "Found no changes.\n";
            unlink("$fileCddId.bak") if (-e "$fileCddId.bak");
            exit(0);
        }
    }

    #
    print STDERR "Decompress :: cddid.tbl.gz\n";
    $cmd = "$main::CMD_convrps -motifout -FILE=$fileCddId > $dir/cddid.out";
    system("$cmd");

    #
    my($dbname) = $main::DBNAME_ACCUM;
    my($dbOpt) = {};
    my($tabName) = 'Motif';
    my($tabOpt) = {};

    print STDERR "Create table :: ${dbname}::${tabName}\n";
    my($db) = new MBGD::DB($dbname, $dbOpt);
    if ($db->{'conn'} =~ /^\s*$/) {
        die("Can not connect DB[$dbname]");
    }
    $tabOpt->{'tablename'} = lc($tabName);
    my($tab) = new MBGD::DBTable($db,
                                 $tabName,
                                 $tabOpt);
    $tab->recreate_table();

    print STDERR "Load motif data\n";
    my($sql) = "load data local infile '$dir/cddid.out' into table "
             . lc($tabName)
             . "(motlib, motid, motname, program, length, descr)";
    $db->execute($sql);

    return;
}

###############################################################################
if ($0 eq __FILE__) {
    my($dir) = $main::DIR;
    if (! $main::DIR) {
        $dir = $main::DIR_db_cdd;
    }
    mkpath($dir, 0, 0750) if (! -e "$dir");

    my($fileCddId) = shift(@ARGV);
    $fileCddId = "$dir/cddid.tbl.gz" if (! $fileCddId);
    if (! $main::DOWNLOAD && ! $fileCddId && ! -e "$fileCddId") {
        printUsage();
        exit(0);
    }

    createMotif($dir, $fileCddId);
}

1;#
