#!/usr/bin/perl -s

###############################################################################
#
###############################################################################
use GDBM_File;
use File::Path;
use MbgdUserGenomeCommon;
require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";
require 'libMBGDaxes.pl';

###############################################################################
if ($0 eq __FILE__) {
    my(%specHash);
    my(@allSpec);
    my($spec);
    my($dir_tit);

    # STDERR ˽ϤƤե˽
    &openLogfile($log);

    # оݤʪ
    undef(%specHash);
    undef(@allSpec);
    foreach $spec (@ARGV) {
        $specHash{"$spec"} = 1;
    }
    @allSpec = keys(%specHash);
    if (! @allSpec) {
	if($current) {
		@allSpec = &MBGD_GetAllGenomes('dbi:mysql:mbgd');
	} else {
		@allSpec = &MBGD_GetAllGenomes(); ### mbgd_work
	}
    }

    $dir_spec = "$DIR_species";
    if ($usergenome) {
        my($dirUserGenome) = MbgdUserGenomeCommon::getDirBaseUserGenome($usergenome);
        $dir_tit = "$dirUserGenome/database/sptit";
        $dir_spec = "$dirUserGenome/species";
    }
    elsif ($current){
	$dir_tit = "$DIR_database/sptit";
    }else{
	$dir_tit = "$DIR_work/sptit";
    }
    mkpath("$dir_tit", 0, 0750);

    foreach $spec (sort(@allSpec)) {
        $file_tit = "$dir_tit/sptit.$spec";
#next if (-f $file_tit);
        &write_titfile($spec, $file_tit);
        &create_dbm($spec, $dir_tit);
    }
    exit;
}

###############################################################################
#
sub write_titfile {
    my($org, $file_tit) = @_;
    my($file);
    my(@field);
    my($orfname, $genename, $product, $annot);

    open(FILE_TIT, ">$file_tit") || die "Can't open $file_tit";
    foreach $file (<$dir_spec/$org/MBGD/data/*.gene>) {
        open(FILE, $file) || die "Can't open $file";
        while (<FILE>) {
            chomp();

            @field = split(/\t/);
            $orfname  = $field[1];
            $genename = $field[2];
            $product  = $field[10];
            $annot    = '';

            print FILE_TIT "$org:" if ($org);
            print FILE_TIT "$orfname\t[$genename]\t$product\t$annot\n";

            $orfname  = '';
            $genename = '';
            $product  = '';
            $annot    = '';
        }
    }
    close(FILE);
    close(FILE_TIT);

    return;
}

###############################################################################
#
sub create_dbm {
    my($sp, $dir) = @_;
    my($sptit);
    my($TitFile, $pos);
    my(%dbmtit);

    $sptit = "${sp}_tit";
    $TitFile = "$dir/sptit.$sp";

    unlink "$TitFile.dir" if (-f "$TitFile.dir");
    unlink "$TitFile.pag" if (-f "$TitFile.pag");
    open($sptit, $TitFile) || die "Can't open $TitFile\n";
    tie %dbmtit, 'GDBM_File', "$TitFile.pag", &GDBM_WRCREAT, 0744
			|| die "Can't open dbmfile for $TitFile\n";

    $pos = tell $sptit;
    while (<$sptit>) {
        my($orfname, $genename) = split;
        my($sp0,$orf) = split(/:/, $orfname);
        $orf =~ tr/a-z/A-Z/;
        $orfname = "$sp:$orf";
        $dbmtit{$orfname} = $pos;
        $pos = tell $sptit;
    }
    untie %dbmtit;
    close($sptit);
}

###############################################################################
1;#
###############################################################################
