#!/usr/bin/perl -s
use strict;
use File::Path;
use FileHandle;
require "MBGD_commonPath.pl";

###############################################################################
sub printUsage {
    print STDERR "Usage :: $0 -DB=FILE_DB -MX=<# of sequences> -MXJOB=<# of jobs> -OUT=FILE_OUTPUT FILE_PROTSEQ\n";
}

###############################################################################
if ($0 eq __FILE__) {
    # hmmer $BMQ(B DB
    my($db) = "$ENV{'MBGD_HOME'}/package/tigrfams/6.0/TIGRFAMs_6.0_HMM.LIB";
    $db = $main::DB if ($main::DB && (-e $main::DB));

    # $B#1(BJOB$B$G=hM}$9$kG[Ns?t(B
    my($mx) = 100;
    $mx = $main::MX if ($main::MX && (0 < $main::MX));

    # $BJBNs<B9T(B JOB $B?t(B
    my($mxJob) = 10;
    $mxJob = $main::MXJOB if ($main::MXJOB && (0 < $main::MXJOB));

    # $B=PNO%U%!%$%k(B
    my($fileOut) = "hmmer.out";
    $fileOut = $main::OUT if ($main::OUT);

    # $BG[Ns%U%!%$%k(B
    my($fileSeq) = $ARGV[0];
    if ((! $fileSeq) || (! -e $fileSeq)) {
        printUsage();
        exit(0);
    }

    # hmmer $B$N<B9T(B
    my($cmd) = "$main::CMD_exechmmer -CopyAll -MX=$mx -MXJOB=$mxJob -DB='$db' $fileSeq $fileOut";
    system("$cmd");
}

###############################################################################
1;#
###############################################################################
