#!/usr/bin/perl -s

###############################################################################
use DirHandle;
require "MBGD_Conf.pl";
require "libMBGDaxes.pl";
require "libCheckPoint.pl";
require "libProcList.pl";
require "MBGD_commonUpdate.pl";

###############################################################################
#
sub InsertSearchRes {
    my($dirname);
    my($file);
    my($procname);
    my($cmd, $opt);
    my($ret);
    my($dh);

    #
#    $dirname = $DIR_work;
    $homOut = "$DIR_work/homology.blastdpres.out";
    $rpsOut = "$DIR_work/rpsBlastRes";

    $opt = "-DEBUG='$DEBUG' -nolog";

    @procList = (
		  { 'title'    => "m1010LoadHomology",
                    'procname' => "$DIR_build/m1010LoadHomology.pl",
                    'opt'      => "-nolog $homOut" },
                  { 'title'    => "m1020LoadProtMotif_rpsblast",
                    'procname' => "$DIR_build/m1020LoadProtMotif.pl",
                    'opt'      => "-nolog $rpsOut" },
                  { 'title'    => "m1050LoadGeneCategory",
                    'procname' => "$DIR_build/m1050LoadGeneCategory.pl",
                    'opt'      => "-nolog -ALL" },
                  { 'title'    => "m1099Cleanup",
                    'procname' => "$DIR_build/m1099Cleanup.pl",
                    'opt'      => "-nolog -ALL" },
    );

    &doProcList(@procList);

}

###############################################################################
if ($0 eq __FILE__) {
    # STDERR ˽ϤƤե˽
    &openLogfile($main::logfile);

    &InsertSearchRes();

    exit;
}

###############################################################################
1;#
###############################################################################
