#!/usr/bin/perl -s
#use strict;
use MBGD;
use RECOG::RecogProject;
require 'MBGD_Conf.pl';

if (! $TYPE) {
	if ($0 =~ /Homology/i) {
		$TYPE = 'homology';
	} elsif ($0 =~ /ProtMotif/i) {
		$TYPE = 'protmotif';
	}
}
if ($TYPE =~ /homology/i) {
	$Class = "MBGD::Homology";
} elsif ($TYPE =~ /protmotif/i) {
	$Class = "MBGD::ProtMotif";
} elsif ($TYPE =~ /motif/i) {
	$Class = "MBGD::Motif";
}
if ($dbname) {
	$DBI = "dbi:mysql:$dbname";
} elsif ($TYPE =~ /current/i) {
	$DBI = "dbi:mysql:$DBNAME_MBGD";
} elsif ($TYPE =~ /work/i) {
	$DBI = "dbi:mysql:$DBNAME_WORK";
} else {
	$DBI = "dbi:mysql:$DBNAME_ACCUM";
}

#
my($file_base) = @ARGV;
my($recog_proj_ref) = RECOG::RecogProject->new();
my(@proj_id_list) = $recog_proj_ref->get_project_id_list();
my(%spid_hash);

my(@FileNames);
if (scalar(@setid_list) == 0) {
    @FileNames = ( $file_base );
}
else {
    foreach my$proj_id (@proj_id_list) {
        my(@spid_list) = sort($recog_proj_ref->get_spid_list($user, $proj_id));
        foreach my$spid1 (@spid_list) {
            $spid_hash{"$spid1"} = 1;
        }
    }
    my(@spid_list) = sort(keys(%spid_hash));
    foreach my$spid (@spid_list) {
        my($filename) = $file_base . '.' . $spid;
        if (-e $filename) {
            push(@FileNames, $filename);
        }
    }
}

if (! $Class || ! @FileNames) {
	die "Usage: $0 [-dbname=DBNAME] -TYPE=[DBTYPE.]TABLENAME FILENAME\n";
}

print STDERR "Loading data for $Class on $DBI\n";

$db = MBGD::DB->new($DBI);
if ($delete){
	$tablename = MBGD::Schema::get_schema_classname($Class);
	$db->drop_tables($tablename);
}
$tab = $db->get_table($Class, {mode=>'write', create=>1});
if ($ignore) {
	$loadopt->{ignore} = 1;
}
if (! $prio) {
	$loadopt->{prio} = 'low_priority';
}

foreach $filename (@FileNames) {
	if ($BLKSIZ) {
		&loadfile_blk($tab, $filename, $BLKSIZ, $SKIP);
	} else {
		$tab->load_from_file($filename, $loadopt);
	}
}
print STDERR "Done; flushing the table ...\n";
$tab->flush;
print STDERR "Done\n";

sub loadfile_blk {
	my($tab, $filename, $blksiz, $skipblk) = @_;
	my($cnt, $totcnt);
	my($tmpout)= "/tmp/tmp_load_mbgddata.$$";
	open(F, $filename) || die;
	open(O, ">$tmpout") || die;
	while(<F>){
		next if (++$totcnt <= $skipblk);
		print O $_;
		if (++$cnt >= $blksiz) {
			close(O);
			$tab->load_from_file($tmpout, $loadopt);
			open(O, ">$tmpout") || die;
print STDERR "Load...Done: $totcnt\n";
			$cnt = 0;
		}
	}
	close(F);
	if ($cnt) {
		close(O);
		$tab->load_from_file($tmpout, $loadopt);
print STDERR "Load...Done: $totcnt\n";
	}
}
