#!/usr/bin/perl -s

###############################################################################
use File::Path;
use MBGD;
require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";
require "InfoSpec.pl";
require "libMBGDaxes.pl";
require "libCheckPoint.pl";
require "libProcList.pl";

###############################################################################
#
sub BuildData {
    my($add, $all, $refSpid2sp) = @_;
    my(@spidList) = keys(%{$refSpid2sp});
    my(@specList) = values(%{$refSpid2sp});
    my($cmd, $opt);
    my($proc, @procList);
    my($procname, $procopt, $procout);
    my($ret);

    mkpath("$DIR_database.work", 0, 0750);

    #
    @procList = ( { 'title'    => "m1110CopySpecInfo",
                    'procname' => "$DIR_build/m1110CopySpecInfo.pl",
                    'opt'      => "-nolog",
                    'outfile'  => "" },
                  { 'title'    => "m1120CopyHomologyInfo",
                    'procname' => "$DIR_build/m1120CopyHomologyInfo.pl",
                    'opt'      => "-nolog -add=$add @spidList",
                    'outfile'  => "" },
                  { 'title'    => "m1130CopyProtMotifInfo",
                    'procname' => "$DIR_build/m1130CopyProtMotifInfo.pl",
                    'opt'      => "-nolog -add=$add @spidList",
                    'outfile'  => "" },
                  { 'title'    => "m1140ConvTaballFromDb",
                    'procname' => "$DIR_build/m1140ConvTaballFromDb.pl",
                    'opt'      => "-nolog",
                    'outfile'  => "$DIR_database.work/taball.domclust" },
                  { 'title'    => "m1150UpdateTaxTree",
                    'procname' => "$DIR_build/m1150UpdateTaxTree.pl",
#                    'opt'      => "-nolog -USE_FILE -OUT=$DIR_database.work/tax"},
                    'opt'      => "-nolog -OUT=$DIR_database.work/tax"},
                  { 'title'    => "m1190AddGeneInfo",
                    'procname' => "$DIR_build/m1190AddGeneInfo.pl",
                    'opt'      => "-nolog @specList",
                    'outfile'  => "" },
                  { 'title'    => "makeSptitIndexWork",
                    'procname' => "$DIR_build/makeSptitIndex.pl",
                    'opt'      => "-work -nolog $DIR_database.work",
                    'outfile'  => "" }
                );

    # ¹
    &doProcList(@procList);
}

###############################################################################
sub checkUpdSpid {
	my $CHECKDATE = -10;
	if ($main::CHECKDATE) {
		$CHECKDATE = $main::CHECKDATE;
	}
	my(%accSpecDate, %currSpecDate, @updSpids);
	my $currdb = MBGD::DB->new($MYSQL_DB);
	my $accdb = MBGD::DB->new($MYSQL_DBACCUM);
	my $checktime = time + 3600 * 24 * $CHECKDATE;		
	my @F = localtime($checktime);
	my($year,$mon,$mday) = ($F[5], $F[4], $F[3]);
	my $date = sprintf("%02d%02d%02d", $year + 1900, $mon + 1, $mday);
	my (@upd_spec);
	my $aout = $accdb->select_fetch('gene g, proteinseq p',
		{ columns=>"g.spid spid,max(p.udate) udate",
			where=>"g.aaseq=p.id and p.udate >= ${date}000000",
			group=>"g.spid" });
	foreach $res (@{$aout->{INFO}}) {
		$accSpecDate{$res->{spid}} = $res->{udate};
		push(@updspec, $res->{spid});
	}
	my $updspid = join("','", @updspec);
	my $cout = $currdb->select_fetch('gene g, proteinseq p',
		{ columns=>"g.spid spid,max(p.udate) udate",
			where=>"g.aaseq=p.id and g.spid in ('$updspid')",
			group=>"g.spid" } );
	foreach $res (@{$cout->{INFO}}) {
		$currSpecDate{$res->{spid}} = $res->{udate};
	}
	foreach my$spid (keys %accSpecDate) {
		if (! $currSpecDate{$spid} || $currSpecDate{$spid} < $accSpecDate{$spid}){
			print "$spid curr: $currSpecDate{$spid}\taccum: $accSpecDate{$spid}\n";
			push(@updSpids, $spid);
		}
	}

	return @updSpids;
}

###############################################################################
sub getAllSpid {
    my($refSpid2sp) = {};

    my $accdb = MBGD::DB->new($MYSQL_DBACCUM);

    my $opt = {};
    $opt->{'columns'} = "spid, sp";
    $opt->{'order'} = "spid";
    my $ref = $accdb->select_fetch("project", $opt);
	foreach my$res (@{$ref->{INFO}}) {
        $refSpid2sp->{"$res->{'spid'}"} = $res->{'sp'};
	}

    return $refSpid2sp;
}

###############################################################################
# -add=1: copy all data from the current mbgd table (by file copy)
#	before copying data from the $MYSQL_DBACCUM table
# -add=overwrite: overwrite directly on the mbgd_work table
#	rather than copying data from the current mbgd table
###############################################################################
if ($0 eq __FILE__) {
    my(@infoSpecTab);
    my(%spHash);
    my($sp);

    # SET DEFAULT :: ALL
    $main::add = 0;
    $main::all = 1;


    if (! $main::all && ! $main::add) {
    	$main::add = 1;
    }
    if (! $main::all && ! @ARGV) {
        my@updSpids = &checkUpdSpid();
        print "update spid(s): ", join(' ', @updSPids),"\n";
        if (! $main::force) {
            print "OK ? "; $ans = <STDIN>;
            if ($ans !~ /^[yY]/) {
                print "Please specify species name as command line argument\n";
                exit;
            }
        }
        @ARGV = @updSpids;
    }

    # STDERR ˽ϤƤե˽
    &openLogfile($main::logfile);

    # SP  FTP ǥ쥯ȥȤбɤ߹
    $infoSpecTab = &getInfoSpecTab($FILE_spectab);

    my($refSpid2sp) = getAllSpid();

    &BuildData($main::add, $main::all, $refSpid2sp);

    exit;
}

###############################################################################
1;#
###############################################################################
