#!/usr/bin/perl -s

###############################################################################
use DirHandle;
require "MBGD_Conf.pl";
require "MBGD_commonUpdate.pl";

use MBGD;

###############################################################################
#
sub  get_last_gene_update {
	my $dbname = shift;
	my $db = MBGD::DB->new("dbi:mysql:$dbname");
	my $sth = $db->execute("select spid, unix_timestamp( max(udate) ) from gene group by spid");

	while (@a = $sth->fetchrow_array) {
		my($spid, $maxdate) = @a;
		$Info{$spid}->{udate} = $maxdate;
	}
	return;
}
sub  get_pub_year {
	my $dbname = shift;
	my $db = MBGD::DB->new("dbi:mysql:$dbname");
	my $sth = $db->execute("select spid,sp,journal,date_release from project");
	while (@a = $sth->fetchrow_array) {
		my($spid, $sp, $journal, $dateRelease) = @a;
		my(@year) = ($journal =~ /\((\d\d\d\d)\) *$/g);
		$Info{$spid}->{sp} = $sp;
		$Info{$spid}->{pubyear} = $year[$#year];
		$Info{$spid}->{pub-yyyymmdd} = sprintf("%04d%02d%02d", ($dateRelease =~ /(\d+)\-(\d+)\-(\d+)/));
	}
}
sub  calc_weight {
	my(%addWeight);
	open(F, $FILE_specweight);
	while (<F>) {
		($sp, $weight) = split;
		$addWeight{$sp} = $weight;
	}
	close(F);

	foreach $spid (keys %Info) {
		my $pubyear = $Info{$spid}->{pub-yyyymmdd};
		if (! $pubyear) {
			if ($Info{$spid}->{udate}) {
				my @localtime = localtime($Info{$spid}->{udate});
				$pubyear = $localtime[5];	## year
				$pubyear += 1900;
				$pubyear .= '0000';
			}
			$pubyear = 20300000 if (! $pubyear);
		}
		my($sp) = $Info{$spid}->{sp};
		$Info{$spid}->{add_weight} = $addWeight{$sp};
		$Info{$spid}->{weight} = (20300000 - $pubyear)*100 + $Info{$spid}->{add_weight};
	}
}
sub  print_info {
	foreach $sp (keys %Info) {
		print join("\t", $sp,$Info{$sp}->{udate},
			$Info{$sp}->{pubyear},$Info{$sp}->{weight}),"\n";
	}
}

###############################################################################
if ($0 eq __FILE__) {
    my($dbname) = $main::DBNAME_ACCUM;
    if ($main::dbname_accum) {
        $dbname = $main::dbname_accum;
    }

    &openLogfile($log);

    &get_last_gene_update($dbname);
    &get_pub_year($dbname);
    &calc_weight();
    &print_info();

    exit;
}

###############################################################################
1;#
###############################################################################
