#!/usr/bin/perl -s
use strict;
use FileHandle;

$main::FUNC_DBNAME = 'cog_orig';

###############################################################################
#
sub printFunction {
    my($filename) = shift;
    my($line);
    my($lev1) = '';
    my($lev2) = '';
    my($lev3) = '';

    my($fh) = new FileHandle("$filename") || die("Can not open $filename($!)");

    print join("\t", 'dbname', 'level1', 'level2', 'level3', 'name', 'color'), "\n";
    while($line = $fh->getline()) {
        next if ($line =~ /^\s*$/);
        $line =~ s#[\r\n]*##;

        if ($line =~ /^\s(.+)\s*$/) {
            $lev2++;
            print join("\t", $main::FUNC_DBNAME, $lev1, $lev2, $lev3, $1, ''), "\n";
        }
        elsif ($line =~ /^(?:.+)\s*$/) {
            $lev1++;
            $lev2 = '';
            print join("\t", $main::FUNC_DBNAME, $lev1, $lev2, $lev3, $1, ''), "\n";
        }
    }
    $fh->close();
}

###############################################################################
#
sub printGeneFunction {
    my($sp) = shift;
}


###############################################################################
if ($0 eq __FILE__) {

    if ($main::FUNC) {
        printFunction($main::FUNC);
    }

    foreach my$sp (@ARGV) {
        printGeneFunction($sp);
    }
}


###############################################################################
1;#
###############################################################################
