#!/usr/bin/perl -s
use strict;
use MBGD::DB;
require "MBGD_common.pl";
require "InfoSpec.pl";

###############################################################################
#
sub print_usage {
    print STDERR "Usage :: $0 [-ALL] spid1 [ spid2 ... spidN ]\n";

    return;
}

###############################################################################
#
sub print_sep {
    print "+---------+---------+--------+---------+------------+------------+\n";

    return;
}

###############################################################################
#
sub viewUserGenomeData {
    my($db) = shift;
    my($spid) = shift;

    #
    my($tab);
    my($where);
    my($sql);
    my($sth);

    #
    my($project_ref);
    $tab = 'project';
    $where = "spid='$spid'";
    $sql = "select * from $tab where $where";
    $sth = $db->execute($sql);
    if ($sth->rows() == 0) {
        $project_ref->{'sp'} = 'NO DATA';
    }
    else {
        $project_ref = $sth->fetchrow_hashref();
    }

    #
    $tab = 'project p, geneset gs, geneset_chromosome gsc, chromosome c';
    $where = "p.spid='$spid' and p.id=gs.project_id and gs.selected=1 and gs.id=gsc.geneset_id and gsc.chromosome_id=c.id";
    $sql = "select count(*) as n from $tab where $where";
    $sth = $db->execute($sql);
    my($chromosome_ref) = $sth->fetchrow_hashref();

    #
    $tab = 'project p, geneset gs, geneset_gene gsg, gene g';
    $where = "p.spid='$spid' and p.id=gs.project_id and gs.selected=1 and gs.id=gsg.geneset_id and gsg.gene_id=g.id";
    $sql = "select count(*) as n from $tab where $where";
    $sth = $db->execute($sql);
    my($gene_ref) = $sth->fetchrow_hashref();

    #
    $tab = 'project p, geneset gs, geneset_gene gsg, gene g, transcript t';
    $where = "p.spid='$spid' and p.id=gs.project_id and gs.selected=1 and gs.id=gsg.geneset_id and gsg.gene_id=g.id and g.id=t.gene_id and t.seqreg_id>1";
    $sql = "select count(*) as n from $tab where $where";
    $sth = $db->execute($sql);
    my($geneseq_ref) = $sth->fetchrow_hashref();

    #
    $tab = 'project p, geneset gs, geneset_gene gsg, gene g, transcript t';
    $where = "p.spid='$spid' and p.id=gs.project_id and gs.selected=1 and gs.id=gsg.geneset_id and gsg.gene_id=g.id and g.id=t.gene_id and t.proteinseq_id > 0";
    $sql = "select count(*) as n from $tab where $where";
    $sth = $db->execute($sql);
    my($protseq_ref) = $sth->fetchrow_hashref();

    #
#    print_sep();
    printf("| %-7s | %-7s | %6d | %7d | %10d | %10d |\n",
        $spid,
        $project_ref->{'sp'},
        $chromosome_ref->{'n'},
        $gene_ref->{'n'},
        $geneseq_ref->{'n'},
        $protseq_ref->{'n'},
        );

    return;
}

###############################################################################
if ($0 eq __FILE__) {

    #
    my($dbname) = $main::DBNAME_ACCUM;
    if (defined($main::DBNAME)) {
        $dbname = $main::DBNAME;
    }

    #
    my($db) = MBGD::DB->new($dbname);

    #
    my(@spid_list) = @ARGV;
    if (defined($main::ALL)) {
        my($sql) = "select spid from project order by spid";
        my($sth) = $db->execute($sql);
        while (my$ref=$sth->fetchrow_hashref()) {
            push(@spid_list, $ref->{'spid'});
        }
    }
    elsif (scalar(@spid_list) == 0) {
        print_usage();
        exit(0);
    }

    #
    print_sep();
    print "| spid    | sp      | chr(#) | gene(#) | geneseq(#) | protseq(#) |\n";
    print_sep();
    foreach my$spid (sort @spid_list) {
        viewUserGenomeData($db, $spid);
    }
    print_sep();
    my($n) = scalar(@spid_list);
    print "$n species\n";
}
1;#

