#include<stdio.h>
#include "domclust.h"

#define BLKSIZ 5000

static Alloc_Object *clustTreeObj;

initClustTreeNode()
{
	if (clustTreeObj == NULL) {
		clustTreeObj = init_alloc_object(sizeof(TreeNode),BLKSIZ);
	}
}
TreeNode *createTreeNode(Node *node)
{
	TreeNode *tnode = (TreeNode *) memalloc(clustTreeObj);
	if (! tnode) {
		allocError("TreeNode");
	}
	tnode->node = node;
	tnode->child1 = tnode->child2 = NULL;
	tnode->dom = NULL;
	clearSPflag(tnode->spflag);
	return tnode;
}
setTreeNode(TreeNode *treenode, Node *node)
{
	treenode->node = node;
}
ClustTree_addChild(TreeNode *parent, TreeNode *child, int childnum)
{
	if (childnum==1) {
		parent->child1 = child;
	} else {
		parent->child2 = child;
	}
	child->parent = parent;
}
ClustTree_isLeaf(TreeNode *tnode)
{
	return ((tnode->dom) ? 1 : 0);
}

static Node *rootnode;

pList *convClustTree(NodeSet *nodes)
{
	Node *node;
	TreeNode *ret_tnode, *tnode;
	NodeSetIter iter;
	pList *root_treeNodes;
	int type;

	initClustTreeNode();
	getRootInit(&iter, nodes, -1, 1);
	root_treeNodes = create_pList();
	while (node = getRootNext(&iter)) {
		rootnode = node;
		type = convClustTree_sub(node, &ret_tnode);
		if (ret_tnode) {
			if (node != ret_tnode->node){
				if (type == 1 || type == 2) {
					tnode = createTreeNode(node);
					ClustTree_addChild(tnode, ret_tnode, type);
					pushList(root_treeNodes, tnode); 
				} else {
					makeOutRootNode(ret_tnode->node);
					deleteRootNode(node);
					pushList(root_treeNodes, ret_tnode); 
				}
			} else {
				pushList(root_treeNodes, ret_tnode); 
			}
		}
/*
		printf("Cluster\n");
		printClustTree(ret_tnode);
		printf("\n");
*/
	}
	assignSpecFlag(root_treeNodes);
	return root_treeNodes;
}


int tmpcount;
pList *root_treeNodes;
Node *root00;

convClustTree_fromHom(NodeSet *nodes, pList *origRoots, pList **allClust_hom, pList **allClust_plain)
{
	Node *node;
	TreeNode *tnode;
/*
	NodeSetIter iter;
*/
	listIter iter;
	int type;
	SubClusterInfo *homInfo;

	initClustTreeNode();
	setListIter(&iter, origRoots, 1); /* origRoots = HomClustRoots */
	*allClust_hom = create_pList();
	if (allClust_plain) {
		*allClust_plain = create_pList();
	}

	while (node = (Node *) getListIter(&iter)) {
/*
root00 = node;
*/
		root_treeNodes = create_pList();
		findOrthoRoot(node); /* orthoroots are gathered in root_treeNodes */
		homInfo = createSubClusterInfo();
		homInfo->members = root_treeNodes;
		tnode = createTreeNode(node);
		homInfo->root = tnode;
		pushList(*allClust_hom, homInfo);
		if (allClust_plain) {
			pushListAll(*allClust_plain, root_treeNodes);
		}
	}
	clearAllMarks(origRoots);
	if (allClust_plain) {
		assignSpecFlag(*allClust_plain);
	}
}
makeClustTreeHom(pList *clustRoots, pList *origRoots, pList **allClust_hom)
{
	
	listIter iter;
	Node *node;
	setListIter(&iter, origRoots, 1);
	while (node = (Node *) getListIter(&iter)) {
	}
}

findOrthoRoot(Node *node)
{
	TreeNode *treeNode;
	TreeNode *retnode;
	Domain *dom;
	int type;

	/* hom root */
	if (nodeMarked(node)) {
		/* skip duplicate: already visited */
	} else if ( isRoot(node) ) {
		rootnode = node;
		markNode(node);
		type = convClustTree_sub(node, &retnode);
/*
if (retnode->node->id==3075055){
printNode(node);
printNode(retnode);
printf("%d,%d\n",type,retnode->node->id);
}
*/
		if (retnode) {
			if (node != retnode->node){
/*
printf("type=%d\n",type);
printNode(node);putchar(' ');
printNode(retnode->node);putchar('\n');
*/
				if (type == 1 || type == 2) {
					/* flanking node */
					treeNode = createTreeNode(node);
					ClustTree_addChild(treeNode, retnode, type);
					pushList(root_treeNodes, treeNode); 
				} else {
					makeOutRootNode(retnode->node);
					deleteRootNode(node);
					pushList(root_treeNodes, retnode); 
				}
			} else {
				pushList(root_treeNodes, retnode); 
			}
		} else {
			/** deleted cluster **/
/*
if (node->id==3075055){
printf("DEL\n");
}
*/
			deleteRootNode(node);
		}
	} else if (isFlankNode1(node)) {
		findOrthoRoot(node->child->node1);
	} else if (isFlankNode2(node)) {
		findOrthoRoot(node->child->node2);
	} else if (isIntNode(node)) {
		findOrthoRoot(node->child->node1);
		findOrthoRoot(node->child->node2);
	} else {
		/** leaf **/
		if (node->domains) {
			getDomainMark(node->domains, rootnode, &dom);
			if (dom) {
				treeNode = createTreeNode(node);
				treeNode->dom = dom;
				pushList(root_treeNodes, treeNode); 
/*
printf("ttt:"); printNode(root00); printf(" "); printNode(node); printf("\n");
if (root00->id < node->id) {
}
*/
			} else {
			}
		}
	}
}

convClustTree_sub(Node *node, TreeNode **retnode)
{
	TreeNode *treeNode;
	TreeNode *retnode1, *retnode2;
	Domain *dom;

	if (isFlankNode1(node)) {
		convClustTree_sub(node->child->node1, &retnode1);
		*retnode = retnode1;
		return 1;
	} else if (isFlankNode2(node)) {
		convClustTree_sub(node->child->node2, &retnode2);
		*retnode = retnode2;
		return 2;
	} else if (isIntNode(node)) {
		convClustTree_sub(node->child->node1, &retnode1);
		convClustTree_sub(node->child->node2, &retnode2);
		treeNode = createTreeNode(node);
		if (retnode1 && retnode2) {
			ClustTree_addChild(treeNode, retnode1, 1);
			ClustTree_addChild(treeNode, retnode2, 2);
			*retnode = treeNode;
		} else if (! retnode1 && retnode2) {
			*retnode = retnode2;
		} else if (retnode1 && ! retnode2) {
			*retnode = retnode1;
		} else {
			*retnode = NULL;
		}
		return 3;
	} else {
		/** leaf **/
		if (node->domains) {
			getDomainMark(node->domains, rootnode, &dom);
			if (dom) {
				treeNode = createTreeNode(node);
				treeNode->dom = dom;
				*retnode = treeNode;
			} else {
				*retnode = NULL;
			}
		}
		return 0;
	}
}
assignSpecFlag(pList *rootnodes)
{
	listIter iter;
	TreeNode *root;
	setListIter(&iter, rootnodes, 1);
	while (root = (TreeNode*) getListIter(&iter)) {
		assignSpecFlag_sub(root);
	}
}
assignSpecFlag_sub(TreeNode *tnode)
{
	specFlagP spflag1, spflag2;
	specFlag nullSpecFlag;

	/* initialize spflags */
	clearSPflag(nullSpecFlag);
	spflag1 = nullSpecFlag;
	spflag2 = nullSpecFlag;

	if (! tnode->child2 && !tnode->child2) {
		copySPFlag(tnode->node->spflag, tnode->spflag);
		return;
	}
	if (tnode->child1) {
		assignSpecFlag_sub(tnode->child1);
		spflag1 = tnode->child1->spflag;
	}
	if (tnode->child2) {
		assignSpecFlag_sub(tnode->child2);
		spflag2 = tnode->child2->spflag;
	}
	spFlagOR(spflag1, spflag2, tnode->spflag);
}

printClustTree(TreeNode *tnode)
{
	if (ClustTree_isLeaf(tnode)) {
		printDomain(tnode->dom);
	} else {
		printClustTree(tnode->child1);
		printClustTree(tnode->child2);
	}
}
void printTreeNode(TreeNode *tnode)
{
	printNode(tnode->node);
}
TreeNode *dupTreeNode(NodeSet *nodes, TreeNode *tnode)
{
	TreeNode *new_tnode;
	Node *newnode = dupNode(nodes, tnode->node);
	new_tnode = createTreeNode(newnode);
	return new_tnode;
}
