#ifndef _CLUSTER_ASSIGN_H_
#define _CLUSTER_ASSIGN_H_
#include <iostream>
#include "Tree.h"
#include "ClusterNode.h"
#include "HomData.h"
#include "Domain.h"

struct ClustAssignData_sub {
	bool selected;
	double sum_score, sum_pam;
	int count;
	ClustAssignData_sub() : sum_score(0), sum_pam(0), count(0), selected(false) { }
};
struct ClustAssignData {
	string name;
	double sum_score, mean_score;
	double sum_pam, mean_pam;
	double best_val;
	double max_score;
	Domain maxscore_dom;
	double sub_best_score, sub_best_pam;
	vector<ClustAssignData_sub> subdata;
	int count;
	int clustid; 
	ClustAssignData() : subdata() { sum_score = sum_pam = max_score = count = clustid = 0; best_val = -1; }
	Domain *getDomain() {return &maxscore_dom;}
	bool check_subdata(int subtreeid);
	friend ostream& operator<<(ostream& ost, const ClustAssignData& cd);
};

class ClustAssignList {
	vector<ClustAssignData> clustAssignList;
public:
	void addDomain(ClustAssignData *cl);
	void assignDomNum();
	vector<ClustAssignData>::iterator begin() { return clustAssignList.begin(); }
	vector<ClustAssignData>::iterator end() { return clustAssignList.end(); }
};

class ClusterAssignment {
	vector<ClustAssignData> clustAssign;
	map<int, int> clustidIdx;
	static int entireGroupAverage;
	static double missScore, missDist;
	static double bestRatio, bestRatio_forSub;
	static double cutoff;
	static int checkHit;
public:
	ClusterAssignment();
	void addHitList(ClustAssignList *cl);
	static void setParam(double bestRatio, int checkHit, double cutoff=0);
	static void entireGroupAverageMode(double missScore=0.0, double missDist=0.0);
	list<ClustAssignData*> *findAssignment(int clustid);
	DomInfo *createDomInfo();
	void createIndex();
	void printAssignment();
	void addClustAssign(Domain *dom, int clustid, string treenums);
	static ClusterAssignment *assignGeneToClusterAll(HomDataSet *homData, AllClustersInfo *clustInfo);
	static ClustAssignList *assignGeneToCluster(HomDataSet *homData, GeneData *gdata, HomDataList *homList, AllClustersInfo *clustInfo);
	static bool check_cutoff(ClustAssignData *cld);
};
class ReadAssignment {
public:
	static ClusterAssignment *readAssign(const char *filename);
};
#endif
