#ifndef _CLUSTER_NODE_H_
#define _CLUSTER_NODE_H_
#include <iostream>
#include <ext/hash_map>
#include <map>
#include "Domain.h"
//#include "PairDist.h"
#include "MemAlloc.hpp"
#include "Tree.h"
#include "SpecSet.h"

using namespace std;
using namespace __gnu_cxx;

class PairDist;

/***
class ClusterNodeSet {
	int totalNum, leafNum;
	NameHash_t nameHash;
	MemAlloc<ClusterNode> objPool;
	int markedPos;
public:
	vector<ClusterNode *> allNodes;
	ClusterNode *createLeafNode(Domain* _elem);
	ClusterNode *createIntNode(PairDist *pdis);
	void markCurrent();
	int getMarkedPos();
	int getLastPos();
	ClusterNode *getNode(int id) {return allNodes[id];}
	int getTotalNum() {return totalNum;}
};
***/

class ClusterNode : public TreeNode {
	int id;
	Domain *elem;
	PairDist *child;
	ClusterNode *parent;
	int count, effCount;
	bool isRootFlag;
	typedef multimap<string, ClusterNode *> NameHash_t;
	SpecSet spSet; 
	static int totalNum, leafNum;
	static NameHash_t nameHash;
	static MemAlloc<ClusterNode> objPool;
	static int markedPos;
public:
	static vector<ClusterNode *> allNodes;
	static ClusterNode *createLeafNode(Domain* _elem);
	static ClusterNode *createIntNode(PairDist *pdis);
	static void markCurrent();
	static int getMarkedPos();
	static int getLastPos();
	static ClusterNode *getNode(int id) {return allNodes[id];}
	static int getTotalNum() {return totalNum;}

	ClusterNode() {}
	int getID() {return id; }
	string getName() {return elem->getDomName(); }
	Domain* getDomain() {return elem; }
	ClusterNode *getParent() { return parent; }
	ClusterNode *getChild(int cidx);
	PairDist *getPairDist() {return child; }
	double getSimValue();
	SimValue getSimValData();
	double getScore();
	double getDist();
	int getCount() {return count; }
	int getEffCount() {return effCount; }
	void initialize(Domain* _elem);
	static void reset();
	bool isLeaf() { return(child == NULL); }
	bool isRoot() { return isRootFlag; }
	void setRootFlag() { isRootFlag = true; }
	void unsetRootFlag() { isRootFlag = false; }
	SpecSet& getSpSet() {return spSet; }
	string getSpSetString() { return spSet.toString(); }
	static list<ClusterNode*>* listRootNodes();
	void outputNodeScore(FILE *fp, const char *string);
	static void outputScoreData(FILE *fp, const char *string, double score, double dist);
	friend ostream& operator<<(ostream& ost, ClusterNode& cnode) {
		return(ost << *(cnode.elem) << " [" << cnode.id << "]");
	}
	friend class ExecPhyloCut;
};
#endif
