#include <iostream>
#include <list>
#include "Hcluster.h"
#include "DistMat.h"
#include "ClusterTree.h"
#include "DEBUG.h"

using namespace std;

//class Hcluster {

double Hcluster::missDist = 260;
double Hcluster::missScore = 55;

Hcluster::Hcluster(DistMat* _dmat, double _cutoff, double _missDist, double _phylocutratio, bool _noCutoffCheck)
	: dmat(_dmat), cutoff(_cutoff), phylocutratio(_phylocutratio), spSet_flag(false), noCutoffCheck(_noCutoffCheck) {
	if (_missDist) {
		setMissDist(_missDist);
	} else {
		missDist = cutoff * 0.9;
	}
//noCutoffCheck=false;
	if (phylocutratio == 0) {
		phylocutratio = 0.5;
	}
}

void Hcluster::execute() {
	while (true) {
		PairDist *bestDist;
		int ret = dmat->getBestData(bestDist);
		if (ret < 0 || ! noCutoffCheck && cutoff > 0 && bestDist->getSimValData().worseSimValue(cutoff)) {
			break;
		}
		if (bestDist->isDeleted()) {
			bestDist->declRef();
			continue;
		}
		if (DEBUG::verbose_flag) {
			static int i;
			if (++i % 10 == 0) {
				cerr << ".";
			}
		}
		if (DEBUG::debug_flag >= 2) {
			cout << "Best:" << bestDist->getSimValue() << ": " << *bestDist << endl;
		}
		mergeClusters(bestDist);
	}
	if (DEBUG::verbose_flag) {
		cerr << "Done\n";
	}
	vector<ClusterNode *>::reverse_iterator
		p = ClusterNode::allNodes.rbegin();
	vector<ClusterNode *>::reverse_iterator
		endPos = p + (ClusterNode::getLastPos() - ClusterNode::getMarkedPos());
/*
cout << "endpos: " << *endPos << endl;
cout << "rend: " << *(ClusterNode::allNodes.rend()) << endl;
*/

//	while (p != ClusterNode::allNodes.rend()) {
	while (p != endPos) {
		if ((*p)->isRoot()) {
			ClusterTree clustTree(*p);
			if (clustTree.scoreCut(cutoff, &newSPflag) != 0) {
			} else if (spSet_flag) {
				clustTree.phyloCut(phylocutratio, &newSPflag);
			} else {
				clustTree.phyloCut(phylocutratio);
			}
		}
		p++;
	}
}
void Hcluster::mergeClusters(PairDist *bestDist) {
	Nlist nbrlist(dmat, bestDist);
	Trinary *tri;
	PairDist *newPairDist;
	list<PairDist*> newEdges;
	list<PairDist*> oldEdges;
	ClusterNode *newNode = bestDist->mergeNodes();
	if (DEBUG::debug_flag > 3) {
		cout << "NewNode: " << *newNode << endl;
	}
	for (list<Trinary*>::iterator p = nbrlist.begin();
				p != nbrlist.end(); p++) {
		tri = *p;
//cout << "tri>>" << tri << ",n3=" << tri->n3 << endl;
		
		newPairDist = PairDist::create(tri->n3, newNode);
//cout << "id=" << newPairDist->getID() << " " << newNode->getID() << endl;
		tri->calcDist(bestDist, newPairDist);
		if (DEBUG::debug_flag > 3) {
			if (newPairDist->getSimValData().betterSimValue(
				bestDist->getSimValData().increaseSimValue(0.05)
					)) {
				cout << "Error?" << *newPairDist << " " << bestDist->getSimValue() << endl;
			} 
		}
		newEdges.push_back(newPairDist);
		if (tri->e1) oldEdges.push_back(tri->e1);
		if (tri->e2) oldEdges.push_back(tri->e2);
	}
	for (list<PairDist*>::iterator p = newEdges.begin();
			p != newEdges.end(); p++) {
if (DEBUG::debug_flag > 3) {
//if ((*p)->checkName("syn:SLL0240")) {
	cout << "newEdge: " << **p << endl;
//}
}
		dmat->add(*p);
	}
	for (list<PairDist*>::iterator p = oldEdges.begin();
			p != oldEdges.end(); p++) {
if (DEBUG::debug_flag > 3) {
//if ((*p)->checkName("syn:SLL0240")) {
cout << "oldEdge: " << **p << endl;
//}
}
		(*p)->deleteThis();
	}
	checkDeleted(bestDist->getNode(0));
	checkDeleted(bestDist->getNode(1));
	bestDist->deleteThis();
}
void Hcluster::checkDeleted(ClusterNode *node) {
	NodeNbrList *list = dmat->findNeighbors(node);
	list->checkDeleted();
}
/*
void Hcluster::setSpSet(set<string>* spSet) {
	newSPflag.setSpecSet(spSet);
	spSet_flag = true;
}
*/
void Hcluster::setSpSet(SpecSet* spSet) {
	newSPflag = *spSet;
	spSet_flag = true;
}

Trinary *Nlist::createTrinary(PairDist *e1, PairDist *e2, ClusterNode *n3) {
	Trinary tri(e1, e2, n3);
//cout << "create: n3=" << n3 << " " << tri.n3 << endl;
	return trinaryPool.create(tri);
}
Nlist::Nlist(DistMat *dmat, PairDist *bestPair) : trinaryPool(10000) {
//cout << "dmat="<<dmat<<endl;
	NodeNbrList *list1 = dmat->findNeighbors(bestPair->getNode(0));
	NodeNbrList *list2 = dmat->findNeighbors(bestPair->getNode(1));
	list<PairDist*>::iterator iter1 = list1->begin();
	list<PairDist*>::iterator iter2 = list2->begin();
	PairDist *e1 = NULL, *e2 = NULL;
	ClusterNode *n3_1 = NULL, *n3_2 = NULL;
	bool update1, update2;
	Trinary *tri;
//cout << "Nlist" << list1->size() << " " << list2->size() << endl;

ClusterNode *prev_n;
	while (iter1 != list1->end() && iter2 != list2->end()) {
		e1 = *iter1; e2 = *iter2;
		tri = NULL;
		update1 = update2 = false;
		if (e1 == bestPair){
			update1 = true;
		} else if (e2 == bestPair) {
			update2 = true;
		} else {

			if (DEBUG::debug_flag > 2) {
				if (e1 !=NULL && e1->getSimValData().betterSimValue(bestPair->getSimValData().increaseSimValue(0.05))) {
					cout << "Error:1>>" << *e1 << " " << bestPair->getSimValue() << endl;
				}
				if (e2 !=NULL && e2->getSimValData().betterSimValue(bestPair->getSimValData().increaseSimValue(0.05))) {
					cout << "Error:2>>" << *e2 << " " << bestPair->getSimValue() << endl;
				}
			}

			n3_1 = otherNode(e1, bestPair->getNode(0));
			n3_2 = otherNode(e2, bestPair->getNode(1));
			if (n3_1 == bestPair->getNode(1)) {
				update1 = true;
			} else if (n3_2 == bestPair->getNode(0)) {
				update2 = true;
			} else if (n3_1 == n3_2) {
				tri = createTrinary(e1, e2, n3_1);
				update1 = update2 = true;
			} else if (n3_1->getID() < n3_2->getID()) {
				tri = createTrinary(e1, NULL, n3_1);
				update1 = true;
			} else if (n3_1->getID() > n3_2->getID()) {
				tri= createTrinary(NULL, e2, n3_2);
				update2 = true;
			}
		}
		if (tri) {
			nlist.push_back(tri);
		}
		if (update1) {
			++iter1;
		}
		if (update2) {
			++iter2;
		}
	}
	while (iter1 != list1->end()) {
		e1 = *iter1;
		n3_1 = otherNode(e1, bestPair->getNode(0));
		if (n3_1 == bestPair->getNode(1)) {
		} else {
			nlist.push_back(createTrinary(e1, NULL, n3_1));
		}
		e1 = (++iter1 != list1->end()) ? *iter1 : NULL;
	}
	while (iter2 != list2->end()) {
		e2 = *iter2;
		n3_2 = otherNode(e2, bestPair->getNode(1));
		if (n3_2 == bestPair->getNode(0)) {
		} else {
			nlist.push_back(createTrinary(NULL, e2, n3_2));
		}
		e2 = (++iter2 != list2->end()) ? *iter2 : NULL;
	}
}
ClusterNode *Nlist::otherNode(PairDist *e, ClusterNode *n) {
	if (e->getNode(0) == n) {
		return(e->getNode(1));
	} else if (e->getNode(1) == n) {
		return(e->getNode(0));
	} else {
		return(NULL);
	}
}

void Trinary::calcDist(PairDist *best, PairDist* newPairDist) {
	ClusterNode *n1 = best->getNode(0);
	ClusterNode *n2 = best->getNode(1);
	SpecSetInstances *specSetInst = SpecSetInstances::getInstance();
	bool p1 = specSetInst->partialOnlyCluster(n1->getSpSet());
	bool p2 = specSetInst->partialOnlyCluster(n2->getSpSet());
	bool p3 = specSetInst->partialOnlyCluster(n3->getSpSet());

	bool i1 = specSetInst->ignoreOnlyCluster(n1->getSpSet());
	bool i2 = specSetInst->ignoreOnlyCluster(n2->getSpSet());
	bool i3 = specSetInst->ignoreOnlyCluster(n3->getSpSet());

	double dist1, dist2, score1, score2;
	int count1, count2;
	int ignoreflag1 = 0, ignoreflag2 = 0;

//if (0) { /* PRE version omits the following lines*/

	/* "ignore" sequences will be ignored in distance calculation */
	if (i1 && ! i2  && !i3) {
		ignoreflag1 = 1;
	} else if (! i1 && i2  && !i3) {
		ignoreflag2 = 1;
	}
	/*TEMPORAL*/
/**
	if (i1 && ! i2  ) {
		ignoreflag1 = 1;
	} else if (! i1 && i2  ) {
		ignoreflag2 = 1;
	}
**/
//}

	if (ignoreflag1) {
		count1 = dist1 = score1 = 0;
	} else if (e1 != NULL) {
//		count1 = n1->getCount() * n3->getCount();
		count1 = e1->getCount();
		dist1 = e1->getDist();
		score1 = e1->getScore();
	} else if (p1 && p3) {
		count1 = 0;
		dist1 = score1 = 0;
	} else {
		count1 = n1->getEffCount() * n3->getEffCount();
/*
cout << n1->getEffCount() << "(" << n1->getCount() <<")"<< endl;
cout << n3->getEffCount() << "(" << n3->getCount() <<")"<< endl;
*/
		dist1 = Hcluster::missDist;
		score1 = Hcluster::missScore;
	}

	if (ignoreflag2) {
		count2 = dist2 = score2 = 0;
	} else if (e2 != NULL) {
//		count2 = n2->getCount() * n3->getCount();
		count2 = e2->getCount();
		dist2 = e2->getDist();
		score2 = e2->getScore();
	} else if (p2 && p3) {
		count2 = 0;
		dist2 = score2 = 0;
	} else {
		count2 = n2->getEffCount() * n3->getEffCount();
		dist2 = Hcluster::missDist;
		score2 = Hcluster::missScore;
	}

/*
	int count1 = n1->getCount() * n3->getCount();
	int count2 = n2->getCount() * n3->getCount();
	double dist1 = (e1 != NULL) ? e1->getDist() : 
			(p1 && p3 ? 0 : Hcluster::missDist);
	double dist2 = (e2 != NULL) ? e2->getDist() :
			(p2 && p3 ? 0 : Hcluster::missDist);
	double score1 = (e1 != NULL) ? e1->getScore() : Hcluster::missScore;
	double score2 = (e2 != NULL) ? e2->getScore() : Hcluster::missScore;
*/

	double newdist = ((dist1 * count1)+(dist2 * count2))
					/ (count1 + count2);
	double newscore = ((score1 * count1)+(score2 * count2))
					/ (count1 + count2);
	newPairDist->setScores(newdist, newscore);
	newPairDist->setCount( count1 + count2 );
}

