#ifndef _OPTIONS_H_
#define _OPTIONS_H_

struct Options {
	int simtype;
	double cutoff;
	double missscore;
	double missdist;
	double phylocutratio;
	double bestRatio4Assign;
	double um_tolerance;
	int distscale;
	int taxMapOut;
	int outputScore;
	int min_alilen;
	int outputStyle;
	int entireGroupAverage;
	int checkHit4Assign;
	int corrDist;
	int sequential;
	int readEachCluster;
	int printAssign;
	int  assignOnly;
	char *taxMapSpecList;
	char *metaSpecList;
	char *metaSpecPref;
	char *partialSpecList;
	char *taxinfo_filename, *scoreout_filename;
	bool noReplaceSpTreeLeafName;
	Options() {
		simtype=-1;
		cutoff = missscore = missdist = phylocutratio = um_tolerance = 0.0;
		min_alilen = distscale = 0;
		taxMapOut = outputScore = 0;
		corrDist = 0;
		outputStyle = 1; // TREEOUT
		entireGroupAverage = 0;
		readEachCluster = sequential = printAssign = assignOnly= 0;
		bestRatio4Assign = -1.0, checkHit4Assign = -1;
		taxinfo_filename = scoreout_filename =
			taxMapSpecList = metaSpecList = metaSpecPref = partialSpecList = NULL;
		noReplaceSpTreeLeafName = false;
	}
};
#endif
