#include "SpecSetInstances.h"
#include <iostream>
#include <cstring>

using namespace std;

static void setSpecList(char *splist, char *prefstr, SpecSet* spSet);

SpecSetInstances* SpecSetInstances::instance = NULL;

void SpecSetInstances::setSpecialSpecies(char *metaPref, char *metaList, char *taxQueryList, char *partialList, int _spnum) {
	setMetaSpecies(metaList, metaPref);
	if (taxQueryList) {
		setTaxQuerySpecies(taxQueryList);
	} else {
		taxQuery_SpecSet.copySpecSet(meta_SpecSet);
	}
	if (partialList) {
		setPartialSpecies(partialList);
	} else {
		partial_SpecSet.copySpecSet(meta_SpecSet);
	}
	addIgnoreSpecies(&meta_SpecSet);
	spnum_in_sptree = _spnum;
}

/* adding species not defined in SpecTree into ignore_specSet */
void SpecSetInstances::addUndefinedSpecies(int beginIdx) {
	if (beginIdx == 0) {
		beginIdx = spnum_in_sptree;
	}
	if (SpecSet::getSPnum() > beginIdx) {
		SpecSet undefSpSet;
		for (int i = beginIdx; i < SpecSet::getSPnum(); i++) {
			undefSpSet.setSpecSet(i);
		}
		addIgnoreSpecies(&undefSpSet);
	}
}
void SpecSetInstances::addIgnoreSpecies(SpecSet *spSet) {
	ignore_SpecSet.setSpecSet(spSet);
	for (int i = 0; i < SpecSet::getSPnum(); i++) {
		if (spSet->getSpFlag(i)) {
			SpecSet::setSPweight(i, 0.0);
		}
	}
	unknown_SpecSet.copySpecSet(ignore_SpecSet);
}

void SpecSetInstances::setMetaSpecies(char *specList, char *pref) {
	setSpecList(specList, pref, &meta_SpecSet);
}
void SpecSetInstances::setTaxQuerySpecies(char *specList) {
	setSpecList(specList, NULL, &taxQuery_SpecSet);
}
void SpecSetInstances::setPartialSpecies(char *specList) {
	setSpecList(specList, NULL, &partial_SpecSet);
}
/*
void SpecSetInstances::setUnknownSpecies(char *specList) {
	setSpecList(specList, NULL, &taxQuery_SpecSet);
}
*/

bool SpecSetInstances::unknownOnlyCluster(const SpecSet& spSet) {
	return (specFlagMaskCheck(spSet, unknown_SpecSet) == 2);
}
bool SpecSetInstances::knownOnlyCluster(const SpecSet& spSet) {
	return (specFlagMaskCheck(spSet, unknown_SpecSet) == 0);
}
bool SpecSetInstances::taxQueryCluster(const SpecSet& spSet) {
	return (specFlagMaskCheck(spSet, taxQuery_SpecSet) == 2);
}
bool SpecSetInstances::taxKnownCluster(const SpecSet& spSet) {
	return (specFlagMaskCheck(spSet, taxQuery_SpecSet) == 0);
}
bool SpecSetInstances::partialOnlyCluster(const SpecSet& spSet) {
	return (specFlagMaskCheck(spSet, partial_SpecSet) == 2);
}
bool SpecSetInstances::ignoreOnlyCluster(const SpecSet& spSet) {
	return (specFlagMaskCheck(spSet, ignore_SpecSet) == 2);
}

bool SpecSetInstances::checkPartial(const string& spname) {
	return (partial_SpecSet.getSpFlag(spname));
}

bool SpecSetInstances::taxQueryMode() {
	return (taxQuery_SpecSet.count() > 0);
}

void setSpecList(char *splist, char *prefstr, SpecSet* spSet)
{
	int i;
	int mchlen;
	char *spname;
	set<string> specHash;

	if (prefstr == NULL && splist == NULL) return;

	if (splist) {
		char *strtok_in = splist;
		while (spname = strtok(strtok_in, ",")) {
			string str_spname = string(spname);
			specHash.insert( str_spname );
			strtok_in = NULL;
			SpecSet::addNewSpecies( str_spname );
		}
	}
	if (prefstr) {
		mchlen = strlen(prefstr);
	}
	for (i = 0; i < spSet->getSPnum(); i++) {
		string spName = SpecSet::getSPname(i);
		if (splist) {
			set<string>::iterator p = specHash.find(spName);
			if (p != specHash.end()) {
				spSet->setSpecSet(i);
				continue;
			}
		}
		if (prefstr) {
			if (strncmp(spName.c_str(), prefstr, mchlen) == 0) {
				spSet->setSpecSet(i);
			}
		}
	}
}

